/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.textareaquery;

import com.imcode.oeplatform.flowengine.queries.textareaquery.TextAreaQuery;
import com.imcode.oeplatform.flowengine.queries.textareaquery.TextAreaQueryCRUD;
import com.imcode.oeplatform.flowengine.queries.textareaquery.TextAreaQueryInstance;
import com.nordicpeak.flowengine.enums.QueryState;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.InstanceMetadata;
import com.nordicpeak.flowengine.interfaces.MutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.MutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.Query;
import com.nordicpeak.flowengine.interfaces.QueryInstance;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUDCallback;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryInstance;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryProviderModule;
import com.nordicpeak.flowengine.utils.JTidyUtils;
import com.nordicpeak.flowengine.utils.TextTagReplacer;
import java.lang.reflect.Field;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.utils.FCKUtils;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfile;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.TooLongContentValidationError;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLGenerator;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;
import se.unlogic.webutils.url.URLRewriter;

public class TextAreaQueryProviderModule
extends BaseQueryProviderModule<TextAreaQueryInstance>
implements BaseQueryCRUDCallback {
    private static final int DEFAULT_MAX_LENGTH = 65536;
    private AnnotatedDAO<TextAreaQuery> queryDAO;
    private AnnotatedDAO<TextAreaQueryInstance> queryInstanceDAO;
    private TextAreaQueryCRUD queryCRUD;
    private QueryParameterFactory<TextAreaQuery, Integer> queryIDParamFactory;
    private QueryParameterFactory<TextAreaQueryInstance, Integer> queryInstanceIDParamFactory;

    protected void createDAOs(DataSource dataSource) throws Exception {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)TextAreaQueryProviderModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(((Object)((Object)this)).getClass().getResourceAsStream("DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        SimpleAnnotatedDAOFactory daoFactory = new SimpleAnnotatedDAOFactory(dataSource);
        this.queryDAO = daoFactory.getDAO(TextAreaQuery.class);
        this.queryInstanceDAO = daoFactory.getDAO(TextAreaQueryInstance.class);
        this.queryCRUD = new TextAreaQueryCRUD((AnnotatedDAOWrapper<TextAreaQuery, Integer>)this.queryDAO.getWrapper(Integer.class), (BeanRequestPopulator<TextAreaQuery>)new AnnotatedRequestPopulator(TextAreaQuery.class), "TextAreaQuery", "query", null, this);
        this.queryIDParamFactory = this.queryDAO.getParamFactory("queryID", Integer.class);
        this.queryInstanceIDParamFactory = this.queryInstanceDAO.getParamFactory("queryInstanceID", Integer.class);
    }

    public Query createQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        TextAreaQuery query = new TextAreaQuery();
        query.setQueryID(descriptor.getQueryID());
        this.queryDAO.add((Object)query, transactionHandler, null);
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query importQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        TextAreaQuery query = new TextAreaQuery();
        query.setQueryID(descriptor.getQueryID());
        query.populate(descriptor.getImportParser().getNode(XMLGenerator.getElementName(query.getClass())));
        this.queryDAO.add((Object)query, transactionHandler, null);
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor) throws SQLException {
        TextAreaQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        TextAreaQuery query = this.getQuery(descriptor.getQueryID(), transactionHandler);
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public QueryInstance getQueryInstance(MutableQueryInstanceDescriptor descriptor, String instanceManagerID, HttpServletRequest req, User user, InstanceMetadata instanceMetadata) throws SQLException {
        TextAreaQueryInstance queryInstance;
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance = new TextAreaQueryInstance();
        } else {
            queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
            if (queryInstance == null) {
                return null;
            }
        }
        queryInstance.setQuery(this.getQuery(descriptor.getQueryDescriptor().getQueryID()));
        if (queryInstance.getQuery() == null) {
            return null;
        }
        if (req != null) {
            FCKUtils.setAbsoluteFileUrls((Object)queryInstance.getQuery(), (String)(RequestUtils.getFullContextPathURL((HttpServletRequest)req) + this.ckConnectorModuleAlias));
            URLRewriter.setAbsoluteLinkUrls((Object)queryInstance.getQuery(), (HttpServletRequest)req, (boolean)true);
        }
        TextTagReplacer.replaceTextTags((Object)queryInstance.getQuery(), (SiteProfile)instanceMetadata.getSiteProfile());
        queryInstance.set(descriptor);
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance.copyQueryValues();
        }
        return queryInstance;
    }

    private TextAreaQuery getQuery(Integer queryID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        return (TextAreaQuery)this.queryDAO.get(query);
    }

    private TextAreaQuery getQuery(Integer queryID, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        return (TextAreaQuery)this.queryDAO.get(query, transactionHandler);
    }

    private TextAreaQueryInstance getQueryInstance(Integer queryInstanceID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{TextAreaQueryInstance.QUERY_RELATION});
        query.addParameter(this.queryInstanceIDParamFactory.getParameter((Object)queryInstanceID));
        return (TextAreaQueryInstance)((Object)this.queryInstanceDAO.get(query));
    }

    public void save(TextAreaQueryInstance queryInstance, TransactionHandler transactionHandler) throws Throwable {
        if (queryInstance.getQueryInstanceID() == null || !queryInstance.getQueryInstanceID().equals(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID())) {
            queryInstance.setQueryInstanceID(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID());
            this.queryInstanceDAO.add((Object)queryInstance, transactionHandler, null);
        } else {
            this.queryInstanceDAO.update((Object)queryInstance, transactionHandler, null);
        }
    }

    public void populate(TextAreaQueryInstance queryInstance, HttpServletRequest req, User user, boolean allowPartialPopulation, MutableAttributeHandler attributeHandler) throws ValidationException {
        String value = req.getParameter("q" + queryInstance.getQuery().getQueryID() + "_value");
        if (StringUtils.isEmpty((String)value)) {
            if (!allowPartialPopulation && queryInstance.getQueryInstanceDescriptor().getQueryState() == QueryState.VISIBLE_REQUIRED) {
                throw new ValidationException(new ValidationError[]{new ValidationError("RequiredField")});
            }
            queryInstance.setValue(null);
            queryInstance.getQueryInstanceDescriptor().setPopulated(false);
            return;
        }
        value = value.trim();
        if (queryInstance.getQuery().getMaxLength() == null && value.length() > 65536 || queryInstance.getQuery().getMaxLength() != null && value.length() > queryInstance.getQuery().getMaxLength()) {
            throw new ValidationException(new ValidationError[]{new TooLongContentValidationError(value.length(), queryInstance.getQuery().getMaxLength() != null ? (long)queryInstance.getQuery().getMaxLength().intValue() : 65536L)});
        }
        queryInstance.setValue(value);
        queryInstance.getQueryInstanceDescriptor().setPopulated(true);
    }

    @WebPublic(alias="config")
    public ForegroundModuleResponse configureQuery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.queryCRUD.update(req, res, user, uriParser);
    }

    public boolean deleteQuery(ImmutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        TextAreaQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return false;
        }
        this.queryDAO.delete((Object)query, transactionHandler);
        return true;
    }

    public boolean deleteQueryInstance(ImmutableQueryInstanceDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        TextAreaQueryInstance queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
        if (queryInstance == null) {
            return false;
        }
        this.queryInstanceDAO.delete((Object)queryInstance, transactionHandler);
        return true;
    }

    public String getTitlePrefix() {
        return ((ForegroundModuleDescriptor)this.moduleDescriptor).getName();
    }

    public void copyQuery(MutableQueryDescriptor sourceQueryDescriptor, MutableQueryDescriptor copyQueryDescriptor, TransactionHandler transactionHandler) throws SQLException {
        TextAreaQuery query = this.getQuery(sourceQueryDescriptor.getQueryID(), transactionHandler);
        query.setQueryID(copyQueryDescriptor.getQueryID());
        this.queryDAO.add((Object)query, transactionHandler, null);
    }

    protected void appendPDFData(Document doc, Element showQueryValuesElement, TextAreaQueryInstance queryInstance) {
        super.appendPDFData(doc, showQueryValuesElement, (BaseQueryInstance)queryInstance);
        if (queryInstance.getQuery().getDescription() != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"Description", (String)JTidyUtils.getXHTML((String)queryInstance.getQuery().getDescription()));
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"isHTMLDescription", (Object)(queryInstance.getQuery().getDescription().contains("<") && queryInstance.getQuery().getDescription().contains(">") ? 1 : 0));
        }
    }
}

