/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.query;

import com.imcode.oeplatform.flowengine.populators.query.QueryInstanceValueBinder;
import com.nordicpeak.flowengine.interfaces.QueryInstance;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyAccessor;

public abstract class BaseQueryInstanceValueBinder<T extends QueryInstance>
implements QueryInstanceValueBinder<T> {
    protected static final UnaryOperator<String> DEFAULT_PROPERTY_NAME_NORMALIZER = name -> {
        char[] chars;
        StringBuilder sb = new StringBuilder(name.length());
        for (char c : chars = name.toCharArray()) {
            if (c == '\"') continue;
            sb.append(c);
        }
        return sb.toString();
    };
    protected QueryInstanceValueBinder.ExceptionHandler exceptionHandler = new RuntimeExceptionHandler();
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final PropertyAccessor accessor;
    protected final String sourceName;
    protected final Object source;
    protected UnaryOperator<String> propertyNameNormalizer;

    public BaseQueryInstanceValueBinder(Object source, String sourceName, UnaryOperator<String> propertyNameNormalizer) {
        this.source = source;
        this.accessor = new BeanWrapperImpl(source);
        this.sourceName = sourceName;
        this.propertyNameNormalizer = propertyNameNormalizer;
    }

    public BaseQueryInstanceValueBinder(Object source, String sourceName) {
        this(source, sourceName, DEFAULT_PROPERTY_NAME_NORMALIZER);
    }

    protected String getValue(String propertyName) {
        String validPropertyName = (String)this.propertyNameNormalizer.apply(propertyName);
        Object value = null;
        try {
            value = this.accessor.getPropertyValue(validPropertyName);
        }
        catch (NotReadablePropertyException e) {
            this.exceptionHandler.handle(new CannotReadProperty(this.source, propertyName, e.getPropertyName()));
        }
        catch (Exception e) {
            this.exceptionHandler.handle(e);
        }
        return value == null ? "" : Objects.toString(value);
    }

    @Override
    public abstract void bindValues(T var1);

    private class RuntimeExceptionHandler
    implements QueryInstanceValueBinder.ExceptionHandler {
        private RuntimeExceptionHandler() {
        }

        @Override
        public void handle(Throwable t) throws RuntimeException {
            try {
                throw t;
            }
            catch (CannotReadProperty e) {
                BaseQueryInstanceValueBinder.this.log.warn((Object)e.getMessage());
            }
            catch (NotReadablePropertyException e) {
                BaseQueryInstanceValueBinder.this.log.warn((Object)String.format("Can't reed property '%s' of object '%s'", e.getPropertyName(), BaseQueryInstanceValueBinder.this.source));
            }
            catch (BeansException e) {
                BaseQueryInstanceValueBinder.this.log.warn((Object)e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(t);
            }
        }
    }

    public static class CannotReadProperty
    extends RuntimeException {
        private final Object source;
        private final String propertyName;
        private final String invalidNodeName;

        public CannotReadProperty(Object source, String propertyName, String invalidNodeName) {
            this.source = source;
            this.propertyName = propertyName;
            this.invalidNodeName = invalidNodeName;
        }

        @Override
        public String getMessage() {
            return String.format("%s: Invalid property '%s(%s)' of bean class [%s]: Bean property '%3$s' is not readable or has an invalid getter method: Does the return type of the getter match the parameter type of the setter?", this.getClass().getSimpleName(), this.propertyName, this.invalidNodeName, this.source.getClass());
        }
    }
}

