/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity.application;

import com.imcode.oeplatform.flowengine.populators.entity.FieldMapper;
import com.imcode.oeplatform.flowengine.populators.entity.FormField;
import com.imcode.oeplatform.flowengine.populators.entity.application.BaseFormField;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQueryInstance;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldValue;
import java.util.HashMap;
import java.util.Map;

public class TextFieldQueryMapper
implements FieldMapper<TextFieldQueryInstance> {
    @Override
    public Map<String, FormField> map(TextFieldQueryInstance query) {
        HashMap<String, FormField> fieldMap = new HashMap<String, FormField>();
        if (query.getValues() != null) {
            for (TextFieldValue textFieldValue : query.getValues()) {
                if (!textFieldValue.getTextField().isExported() || textFieldValue.getTextField().getXsdElementName().isEmpty()) continue;
                String xsdElementName = textFieldValue.getTextField().getXsdElementName();
                FormField<TextFieldValue> field = this.createFormField(textFieldValue);
                fieldMap.put(xsdElementName, field);
            }
        }
        return fieldMap;
    }

    private FormField<TextFieldValue> createFormField(TextFieldValue field) {
        return new BaseFormField<TextFieldValue>(field){

            @Override
            public String getValue() {
                return ((TextFieldValue)this.field).getValue();
            }
        };
    }

    @Override
    public boolean mach(Class queryClass) {
        return queryClass == TextFieldQueryInstance.class;
    }
}

