/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity;

import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.entities.ApplicationFormQuestionGroup;
import com.imcode.oeplatform.flowengine.interfaces.MutableField;
import com.imcode.oeplatform.flowengine.populators.entity.QuestionGroupMapper;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxAlternative;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQuery;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQueryInstance;
import com.nordicpeak.flowengine.interfaces.ImmutableAlternative;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MultipleAlternativeQuestionGroupMapper
extends QuestionGroupMapper<CheckboxQueryInstance> {
    private final Predicate<ImmutableAlternative> alternativeFilter;
    private static List<Class> allowedClassList = Arrays.asList(CheckboxQueryInstance.class);
    private static final Predicate<ImmutableAlternative> DEFAULT_FILTER = alternative -> {
        if (alternative instanceof MutableField) {
            MutableField exportedMutableField = (MutableField)alternative;
            return exportedMutableField.isExported() && !exportedMutableField.getXsdElementName().isEmpty();
        }
        return false;
    };
    private static final Function<ImmutableAlternative, ApplicationFormQuestion> mapper = alternative -> new ApplicationFormQuestion();

    public MultipleAlternativeQuestionGroupMapper() {
        this(DEFAULT_FILTER);
    }

    public MultipleAlternativeQuestionGroupMapper(Predicate<ImmutableAlternative> alternativeFilter) {
        this.alternativeFilter = alternativeFilter;
    }

    @Override
    public void mapQuestions(ApplicationFormQuestionGroup questionGroup, CheckboxQueryInstance queryInstance) {
        ImmutableQueryDescriptor descriptor = queryInstance.getQueryInstanceDescriptor().getQueryDescriptor();
        CheckboxQuery query = queryInstance.getQuery();
        ApplicationFormQuestion question = new ApplicationFormQuestion();
        question.setName(descriptor.getXSDElementName());
        question.setText(descriptor.getName());
        question.setMultiValues(Boolean.valueOf(true));
        question.setMultiVariants(Boolean.valueOf(true));
        question.setSortOrder(descriptor.getSortIndex());
        question.setQuestionType(((Object)((Object)queryInstance)).getClass().getName());
        List values = Collections.emptyList();
        if (queryInstance.getAlternatives() != null) {
            queryInstance.getAlternatives().stream().map(ImmutableAlternative::getName).collect(Collectors.toList());
        }
        question.setValue(values.stream().collect(Collectors.joining()));
        question.setValues(values);
        question.setVariants(query.getAlternatives().stream().map(CheckboxAlternative::getName).collect(Collectors.toList()));
        questionGroup.addQuestion(question);
    }

    @Override
    public boolean mach(Class queryClass) {
        return allowedClassList.contains(queryClass);
    }
}

