<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" version="4.0" encoding="ISO-8859-1"/>

	<xsl:include href="classpath://se/unlogic/hierarchy/core/utils/xsl/Common.xsl"/>
	<xsl:include href="classpath://com/imcode/oeplatform/flowengine/queries/resources/xsl/IvisTemplates.xsl"/>

	<xsl:variable name="globalscripts">
/jquery/jquery.js
/jquery/jquery-ui.js
/ckeditor/ckeditor.js
/ckeditor/adapters/jquery.js
/ckeditor/init.js
	</xsl:variable>	

	<xsl:variable name="scripts">
/common/js/queryadmin.js
/resources/js/queryadmin.js
	</xsl:variable>

	<xsl:template match="Document">	
		
		<div id="RadioButtonQueryProvider" class="contentitem">
		
			<xsl:apply-templates select="validationError"/>
			<xsl:apply-templates select="UpdateRadioButtonQuery"/>
		
		</div>
		
	</xsl:template>
		
	<xsl:template match="UpdateRadioButtonQuery">
	
		<h1><xsl:value-of select="$i18n.UpdateQuery" /><xsl:text>:&#160;</xsl:text><xsl:value-of select="RadioButtonQuery/QueryDescriptor/name" /></h1>
		
		<xsl:apply-templates select="validationException/validationError" />
		
		<form id="updateRadioButtonQueryForm" name="queryAdminForm" method="post" action="{/Document/requestinfo/uri}">
		
			<!--<xsl:call-template name="createCommonFieldsForm">-->
			<xsl:call-template name="createIvisCommonFieldsForm">
				<xsl:with-param name="element" select="RadioButtonQuery" />
			</xsl:call-template>
			
			<xsl:call-template name="createIvisAlternativesForm">
				<xsl:with-param name="alternatives" select="RadioButtonQuery/Alternatives/RadioButtonAlternative" />
				<xsl:with-param name="freeTextAlternative" select="RadioButtonQuery/freeTextAlternative" />
			</xsl:call-template>
				
			<div class="floatright margintop clearboth">
				<input type="submit" value="{$i18n.SaveChanges}" />
			</div>
		
		</form>
		
	</xsl:template>

	<xsl:template match="RadioButtonAlternative">

		<!--<xsl:call-template name="createAlternative">-->
		<xsl:call-template name="createIvisAlternative">
			<xsl:with-param name="alternativeID" select="alternativeID" />
			<xsl:with-param name="sortOrder" select="sortIndex" />
			<xsl:with-param name="value" select="name" />
		</xsl:call-template>
			
	</xsl:template>

	<xsl:template match="validationError[messageKey = 'UpdateFailedRadioButtonQueryNotFound']">
		
		<p class="error">
			<xsl:value-of select="$i18n.RadioButtonQueryNotFound" />
		</p>
		
	</xsl:template>

</xsl:stylesheet>