/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.oauth2.modules.foreground;

import com.imcode.entities.Person;
import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.embed.Email;
import com.imcode.oeplatform.oauth2.modules.foreground.GroupPopulator;
import com.imcode.oeplatform.oauth2.modules.foreground.IvisOAuth2User;
import com.imcode.oeplatform.oauth2.modules.foreground.UserPopulator;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.interfaces.AttributeSource;
import se.unlogic.standardutils.i18n.Language;

public class IvisUserPopulator
implements UserPopulator<User, IvisOAuth2User<MutableUser>> {
    private static final String DEFAULT_ADMIN_ROLE_NAME = "ROLE_ADMIN";
    private static final String DEFAULT_PASSWORD = "f7f76321-6a2b-4941-be0a-2ef0c8e70c25";
    private static final Language DEFAULT_LANGUAGE = Language.English;
    private Language language = DEFAULT_LANGUAGE;
    private GroupPopulator groupPopulator;
    private String password = "f7f76321-6a2b-4941-be0a-2ef0c8e70c25";
    private String adminRoleName = "ROLE_ADMIN";

    IvisUserPopulator(GroupPopulator groupPopulator) {
        this.groupPopulator = groupPopulator;
    }

    @Override
    public void populate(IvisOAuth2User<MutableUser> targetUser, User sourceUser) {
        MutableUser user = targetUser.getUser();
        if (user != null) {
            Person person;
            user.setUsername(this.validateUsername(sourceUser.getUsername()));
            user.setEnabled(sourceUser.isEnabled());
            user.setAdmin(this.isAdmin(sourceUser));
            user.setLanguage(this.language);
            user.setPassword(this.password);
            user.setCurrentLogin(Timestamp.valueOf(LocalDateTime.now()));
            if (user instanceof AttributeSource) {
                AttributeSource attributeSource = (AttributeSource)user;
                attributeSource.addAttribute("ivisUserId", ((Long)sourceUser.getId()).toString());
            }
            if (this.groupPopulator != null) {
                user.setGroups(this.groupPopulator.populate(sourceUser));
            }
            if ((person = sourceUser.getPerson()) != null) {
                String firstName = IvisUserPopulator.isBlank(person.getFirstName()) ? sourceUser.getUsername() : person.getFirstName();
                user.setFirstname(firstName);
                user.setLastname(IvisUserPopulator.blankIfNull(person.getLastName()));
                Map emails = person.getEmails();
                if (emails != null && !emails.isEmpty()) {
                    Email email = (Email)emails.values().iterator().next();
                    user.setEmail(email.getAddress());
                }
            } else {
                user.setFirstname(sourceUser.getUsername());
                user.setLastname("");
                user.setEmail("");
            }
        }
    }

    private boolean isAdmin(User sourceUser) {
        Set sourceRoleSet = sourceUser.getAuthorities();
        if (sourceRoleSet != null && !sourceRoleSet.isEmpty()) {
            for (Role role : sourceRoleSet) {
                if (!this.adminRoleName.equals(role.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected String validateUsername(String username) {
        if ((username = username.trim()) == null || username.trim().length() == 0) {
            username = UUID.randomUUID().toString();
        }
        return username;
    }

    private static String blankIfNull(String string) {
        return string == null ? "" : string;
    }

    private static boolean isBlank(String s) {
        int strLen;
        if (s == null || (strLen = s.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public GroupPopulator<User, ? extends Group> getGroupPopulator() {
        return this.groupPopulator;
    }

    public void setGroupPopulator(GroupPopulator groupPopulator) {
        this.groupPopulator = groupPopulator;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAdminRoleName() {
        return this.adminRoleName;
    }

    public void setAdminRoleName(String adminRoleName) {
        this.adminRoleName = adminRoleName;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }
}

