/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.textfieldquery2;

import com.imcode.oeplatform.flowengine.interfaces.FieldQuery;
import com.imcode.oeplatform.flowengine.queries.DependentQuery;
import com.imcode.oeplatform.flowengine.queries.textfieldquery2.FieldLayout;
import com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextField;
import com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextFieldCRUD;
import com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextFieldQueryInstance;
import com.nordicpeak.flowengine.annotations.TextTagReplace;
import com.nordicpeak.flowengine.queries.basequery.BaseQuery;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.FCKContent;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xml.XMLValidationUtils;
import se.unlogic.webutils.annotations.URLRewrite;

@Table(name="ivis_label_field_queries")
@XMLElement
public class TextFieldQuery
extends BaseQuery
implements DependentQuery,
FieldQuery {
    private static final long serialVersionUID = -842191226937409416L;
    public static final Field TEXT_FIELDS_RELATION = ReflectionUtils.getField(TextFieldQuery.class, (String)"fields");
    @DAOManaged
    @Key
    @XMLElement
    private Integer queryID;
    @FCKContent
    @TextTagReplace
    @URLRewrite
    @DAOManaged
    @WebPopulate(maxLength=65535L)
    @XMLElement(cdata=true)
    private String description;
    @FCKContent
    @TextTagReplace
    @URLRewrite
    @DAOManaged
    @WebPopulate(maxLength=65535L)
    @XMLElement
    private String helpText;
    @DAOManaged
    @WebPopulate(required=true)
    @XMLElement
    private FieldLayout layout;
    @DAOManaged(dontUpdateIfNull=true)
    @OneToMany(autoUpdate=true, autoAdd=true)
    @XMLElement(fixCase=true)
    private List<TextField> fields;
    @DAOManaged(dontUpdateIfNull=true)
    @OneToMany(autoUpdate=true)
    @XMLElement
    private List<TextFieldQueryInstance> instances;

    public static long getSerialversionuid() {
        return -842191226937409416L;
    }

    public Integer getQueryID() {
        return this.queryID;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TextField> getFields() {
        return this.fields;
    }

    public List<TextFieldQueryInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<TextFieldQueryInstance> instances) {
        this.instances = instances;
    }

    public void setQueryID(int queryID) {
        this.queryID = queryID;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFields(List<TextField> alternatives) {
        this.fields = alternatives;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public String toString() {
        if (this.queryDescriptor != null) {
            return this.queryDescriptor.getName() + " (queryID: " + this.queryID + ")";
        }
        return "TextFieldQuery (queryID: " + this.queryID + ")";
    }

    public FieldLayout getLayout() {
        return this.layout;
    }

    public void setLayout(FieldLayout layout) {
        this.layout = layout;
    }

    public String getXSDTypeName() {
        return "TextFieldQuery" + this.queryID;
    }

    public void toXSD(Document doc) {
        Element complexTypeElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
        complexTypeElement.setAttribute("name", this.getXSDTypeName());
        Element complexContentElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexContent");
        complexTypeElement.appendChild(complexContentElement);
        Element extensionElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:extension");
        extensionElement.setAttribute("base", "Query");
        complexContentElement.appendChild(extensionElement);
        Element sequenceElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
        extensionElement.appendChild(sequenceElement);
        Element nameElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
        nameElement.setAttribute("name", "Name");
        nameElement.setAttribute("type", "xs:string");
        nameElement.setAttribute("minOccurs", "1");
        nameElement.setAttribute("maxOccurs", "1");
        nameElement.setAttribute("fixed", this.queryDescriptor.getName());
        sequenceElement.appendChild(nameElement);
        ArrayList<String> fieldElementNames = new ArrayList<String>(this.fields.size());
        if (!CollectionUtils.isEmpty(this.fields)) {
            for (TextField textField : this.fields) {
                sequenceElement.appendChild(doc.createComment(textField.getLabel()));
                String elementName = TextFieldQuery.generateElementName(textField.getLabel(), fieldElementNames);
                Element fieldElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                fieldElement.setAttribute("name", elementName);
                fieldElement.setAttribute("type", "xs:string");
                fieldElement.setAttribute("minOccurs", textField.isRequired() ? "1" : "0");
                fieldElement.setAttribute("maxOccurs", "1");
                sequenceElement.appendChild(fieldElement);
            }
        }
        doc.getDocumentElement().appendChild(complexTypeElement);
    }

    public static String generateElementName(String label, ArrayList<String> fieldElementNames) {
        String elementName = XMLUtils.toValidElementName((String)label);
        if (fieldElementNames.contains(elementName)) {
            int counter = 1;
            while (fieldElementNames.contains(elementName + counter)) {
                ++counter;
            }
            elementName = elementName + counter;
        }
        fieldElementNames.add(elementName);
        return elementName;
    }

    public void populate(XMLParser xmlParser) throws ValidationException {
        ArrayList errors = new ArrayList();
        this.description = (String)XMLValidationUtils.validateParameter((String)"description", (XMLParser)xmlParser, (boolean)false, (Integer)1, (Integer)65535, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.helpText = (String)XMLValidationUtils.validateParameter((String)"helpText", (XMLParser)xmlParser, (boolean)false, (Integer)1, (Integer)65535, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.layout = (FieldLayout)((Object)XMLValidationUtils.validateParameter((String)"layout", (XMLParser)xmlParser, (boolean)true, TextFieldCRUD.LAYOUT_POPULATOR, errors));
        List xmlParsers = xmlParser.getNodes("Fields/TextField");
        if (xmlParsers != null) {
            this.fields = new ArrayList<TextField>();
            for (XMLParser parser : xmlParsers) {
                TextField textField = new TextField();
                textField.populate(parser);
                textField.setQuery(this);
                this.fields.add(textField);
            }
        }
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }
}

