/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class CoolFieldAccessor
extends AbstractPropertyAccessor {
    private final Object rootObject;
    private final Map<String, FieldAccessor> fieldMap = new HashMap<String, FieldAccessor>();

    public CoolFieldAccessor(Object rootObject) {
        Assert.notNull((Object)rootObject, (String)"Root object must not be null");
        this.rootObject = rootObject;
        this.registerDefaultEditors();
        this.setExtractOldValueForEditor(true);
    }

    public final Object getRootInstance() {
        return this.rootObject;
    }

    public final Class<?> getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.hasProperty(propertyName);
    }

    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.hasProperty(propertyName);
    }

    public Class<?> getPropertyType(String propertyPath) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyPath);
        if (fieldAccessor != null) {
            return fieldAccessor.getField().getType();
        }
        return null;
    }

    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyName);
        if (fieldAccessor != null) {
            return new TypeDescriptor(fieldAccessor.getField());
        }
        return null;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyName);
        if (fieldAccessor == null) {
            throw new NotReadablePropertyException(this.getRootClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        return fieldAccessor.getValue();
    }

    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        throw new UnsupportedOperationException();
    }

    private boolean hasProperty(String propertyPath) {
        Assert.notNull((Object)propertyPath, (String)"PropertyPath must not be null");
        return this.getFieldAccessor(propertyPath) != null;
    }

    private FieldAccessor getFieldAccessor(String propertyPath) {
        FieldAccessor fieldAccessor = this.fieldMap.get(propertyPath);
        if (fieldAccessor == null) {
            fieldAccessor = this.doGetFieldAccessor(propertyPath, this.getRootClass());
            this.fieldMap.put(propertyPath, fieldAccessor);
        }
        return fieldAccessor;
    }

    private FieldAccessor doGetFieldAccessor(String propertyPath, Class<?> targetClass) {
        StringTokenizer st = new StringTokenizer(propertyPath, ".");
        FieldAccessor accessor = null;
        Class<?> parentType = targetClass;
        while (st.hasMoreTokens()) {
            String localProperty = st.nextToken();
            Field field = ReflectionUtils.findField(parentType, (String)localProperty);
            if (field == null) {
                return null;
            }
            accessor = accessor == null ? this.root(propertyPath, localProperty, field) : accessor.child(localProperty, field);
            parentType = field.getType();
        }
        return accessor;
    }

    private FieldAccessor root(String canonicalName, String actualName, Field field) {
        return new FieldAccessor(null, canonicalName, actualName, field);
    }

    private class FieldAccessor {
        private final List<FieldAccessor> parents;
        private final String canonicalName;
        private final String actualName;
        private final Field field;

        public FieldAccessor(FieldAccessor parent, String canonicalName, String actualName, Field field) {
            Assert.notNull((Object)canonicalName, (String)"Expression must no be null");
            Assert.notNull((Object)field, (String)"Field must no be null");
            this.parents = this.buildParents(parent);
            this.canonicalName = canonicalName;
            this.actualName = actualName;
            this.field = field;
        }

        public FieldAccessor child(String actualName, Field field) {
            return new FieldAccessor(this, this.canonicalName, this.actualName + "." + actualName, field);
        }

        public Field getField() {
            return this.field;
        }

        public Object getValue() {
            Object localTarget = this.getLocalTarget(CoolFieldAccessor.this.getRootInstance());
            return this.getParentValue(localTarget);
        }

        public void setValue(Object value) {
            Object localTarget = this.getLocalTarget(CoolFieldAccessor.this.getRootInstance());
            try {
                this.field.set(localTarget, value);
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(localTarget.getClass(), this.canonicalName, "Field is not accessible", (Throwable)ex);
            }
        }

        private Object getParentValue(Object target) {
            try {
                ReflectionUtils.makeAccessible((Field)this.field);
                return this.field.get(target);
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(target.getClass(), this.canonicalName, "Field is not accessible", (Throwable)ex);
            }
        }

        private Object getLocalTarget(Object rootTarget) {
            Object localTarget = rootTarget;
            for (FieldAccessor parent : this.parents) {
                localTarget = this.autoGrowIfNecessary(parent, parent.getParentValue(localTarget));
                if (localTarget != null) continue;
                throw new NullValueInNestedPathException(CoolFieldAccessor.this.getRootClass(), parent.actualName, "Cannot access indexed value of property referenced in indexed property path '" + this.getField().getName() + "': returned null");
            }
            return localTarget;
        }

        private Object newValue() {
            Class<?> type = this.getField().getType();
            try {
                return type.newInstance();
            }
            catch (Exception ex) {
                throw new NullValueInNestedPathException(CoolFieldAccessor.this.getRootClass(), this.actualName, "Could not instantiate property type [" + type.getName() + "] to auto-grow nested property path: " + ex);
            }
        }

        private Object autoGrowIfNecessary(FieldAccessor accessor, Object value) {
            if (value == null && CoolFieldAccessor.this.isAutoGrowNestedPaths()) {
                Object defaultValue = accessor.newValue();
                accessor.setValue(defaultValue);
                return defaultValue;
            }
            return value;
        }

        private List<FieldAccessor> buildParents(FieldAccessor parent) {
            ArrayList<FieldAccessor> parents = new ArrayList<FieldAccessor>();
            if (parent != null) {
                parents.addAll(parent.parents);
                parents.add(parent);
            }
            return parents;
        }
    }
}

