/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity.application;

import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.interfaces.JpaNamedEntity;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.services.NamedService;
import com.imcode.services.PersonalizedService;
import imcode.services.IvisServiceFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class IvisConverterFactory
implements ConverterFactory<String, JpaEntity>,
ConditionalConverter {
    private final IvisServiceFactory serviceFactory;

    public IvisConverterFactory(IvisServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public <T extends JpaEntity> Converter<String, T> getConverter(Class<T> targetType) {
        if (JpaPersonalizedEntity.class.isAssignableFrom(targetType)) {
            PersonalizedService service = (PersonalizedService)this.serviceFactory.getServiceFor(targetType);
            return arg_0 -> ((PersonalizedService)service).findFirstByPersonalId(arg_0);
        }
        if (JpaNamedEntity.class.isAssignableFrom(targetType)) {
            NamedService service = (NamedService)this.serviceFactory.getServiceFor(targetType);
            return arg_0 -> ((NamedService)service).findFirstByName(arg_0);
        }
        throw new IllegalArgumentException("No such converter for class \"" + targetType + "\"");
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class targetClass;
        if (String.class.isAssignableFrom(sourceType.getType()) && JpaEntity.class.isAssignableFrom(targetClass = targetType.getType())) {
            return this.serviceFactory.hasServiceFor(targetClass);
        }
        return false;
    }
}

