package com.imcode.oeplatform.flowengine.queries.textfieldquery2;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import com.imcode.oeplatform.flowengine.interfaces.MutableField;
import com.imcode.oeplatform.flowengine.queries.DependentField;
import com.nordicpeak.flowengine.populators.XMLElementNamePopulator;
import se.unlogic.standardutils.annotations.RequiredIfSet;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.populators.PositiveStringIntegerPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLParserPopulateable;
import se.unlogic.standardutils.xml.XMLValidationUtils;

@Table(name = "ivis_label_fields")
@XMLElement
public class TextField extends GeneratedElementable implements Serializable, XMLParserPopulateable, MutableField, DependentField {

	public static Field TEXT_FIELD_QUERY_RELATION = ReflectionUtils.getField(TextField.class, "query");
	
	private static final long serialVersionUID = 8919797448020843470L;

	@DAOManaged(autoGenerated = true)
	@Key
	@XMLElement
	private Integer textFieldID;

	@DAOManaged
	@WebPopulate(required = true, maxLength = 255)
	@XMLElement
	private String label;

	@DAOManaged
	@WebPopulate
	@XMLElement
	private boolean required;

	@DAOManaged
	@WebPopulate(populator=PositiveStringIntegerPopulator.class)
	@XMLElement
	private Integer width;

	//TODO implement client side
	@DAOManaged
	@WebPopulate(populator=PositiveStringIntegerPopulator.class)
	@XMLElement
	private Integer maxContentLength;

	@DAOManaged
	@OrderBy
	@XMLElement
	private Integer sortIndex;

	@DAOManaged
	@WebPopulate
	@OrderBy
	@XMLElement
	private String formatValidator;

	@DAOManaged
	@OrderBy
	@WebPopulate(maxLength=255)
	@RequiredIfSet(paramName="formatValidator")
	@XMLElement
	private String invalidFormatMessage;

	@DAOManaged
	@WebPopulate
	@XMLElement
	private boolean exported;

	@DAOManaged
	@WebPopulate(maxLength = 255, populator=XMLElementNamePopulator.class)
	@RequiredIfSet(paramName="exported")
	@XMLElement
	private String xsdElementName;
	
	@DAOManaged
	@XMLElement
	private boolean setAsAttribute;
	
	@DAOManaged
	@XMLElement
	private String attributeName;	
	
	@DAOManaged(columnName = "queryID")
	@ManyToOne
	@XMLElement
	private TextFieldQuery query;

	@DAOManaged
	@OneToMany
	@XMLElement
	private List<TextFieldValue> values;

	@DAOManaged
	@WebPopulate
	@XMLElement
	private boolean dependsOn;

	@DAOManaged
	@WebPopulate(maxLength = 255, populator=XMLElementNamePopulator.class)
	@RequiredIfSet(paramName="dependsOn")
	@XMLElement
	private String dependencySourceName;

	@DAOManaged
//	@WebPopulate(maxLength = 255, populator=XMLElementNamePopulator.class)
	@WebPopulate(maxLength = 255)
	@RequiredIfSet(paramName="dependsOn")
	@XMLElement
	private String dependencyFieldName;

	public TextField() {

	}

	public Integer getTextFieldID() {

		return textFieldID;
	}

	public void setTextFieldID(Integer textFieldID) {

		this.textFieldID = textFieldID;
	}

	public TextFieldQuery getQuery() {

		return query;
	}

	public void setQuery(TextFieldQuery query) {

		this.query = query;
	}

	public String getLabel() {

		return label;
	}

	public void setLabel(String name) {

		this.label = name;
	}

	@Override
	public String toString() {

		return label + " (textFieldID: " + textFieldID + ")";
	}

	public boolean isRequired() {

		return required;
	}

	public void setRequired(boolean required) {

		this.required = required;
	}

	public Integer getWidth() {

		return width;
	}

	public void setWidth(Integer width) {

		this.width = width;
	}

	public List<TextFieldValue> getValues() {

		return values;
	}

	public void setValues(List<TextFieldValue> values) {

		this.values = values;
	}

	public Integer getSortIndex() {

		return sortIndex;
	}

	public void setSortIndex(Integer sortIndex) {

		this.sortIndex = sortIndex;
	}

	public String getFormatValidator() {

		return formatValidator;
	}

	public void setFormatValidator(String formatValidator) {

		this.formatValidator = formatValidator;
	}

	public Integer getMaxContentLength() {

		return maxContentLength;
	}

	public void setMaxContentLength(Integer maxContentLength) {

		this.maxContentLength = maxContentLength;
	}

	
	public String getInvalidFormatMessage() {
	
		return invalidFormatMessage;
	}

	
	public void setInvalidFormatMessage(String invalidFormatMessage) {
	
		this.invalidFormatMessage = invalidFormatMessage;
	}

	@Override
	public void populate(XMLParser xmlParser) throws ValidationException {

		List<ValidationError> errors = new ArrayList<ValidationError>();
		
		label = XMLValidationUtils.validateParameter("label", xmlParser, true, 1, 255, StringPopulator.getPopulator(), errors);
		required = xmlParser.getPrimitiveBoolean("required");
		
		width = XMLValidationUtils.validateParameter("width", xmlParser, false, PositiveStringIntegerPopulator.getPopulator(), errors);
		maxContentLength = XMLValidationUtils.validateParameter("maxContentLength", xmlParser, false, PositiveStringIntegerPopulator.getPopulator(), errors);
		
		sortIndex = XMLValidationUtils.validateParameter("sortIndex", xmlParser, true, PositiveStringIntegerPopulator.getPopulator(), errors);
		formatValidator = XMLValidationUtils.validateParameter("formatValidator", xmlParser, false, 1, 255, StringPopulator.getPopulator(), errors);
		invalidFormatMessage = XMLValidationUtils.validateParameter("invalidFormatMessage", xmlParser, false, 1, 255, StringPopulator.getPopulator(), errors);
		
		attributeName = XMLValidationUtils.validateParameter("attributeName", xmlParser, false, 1, 255, StringPopulator.getPopulator(), errors);
		
		if(attributeName != null){
			
			setAsAttribute = xmlParser.getPrimitiveBoolean("setAsAttribute");
		}
		
		if(!errors.isEmpty()){

			throw new ValidationException(errors);
		}
		
	}

	
	public boolean isSetAsAttribute() {
	
		return setAsAttribute;
	}

	
	public void setSetAsAttribute(boolean setAsAttribute) {
	
		this.setAsAttribute = setAsAttribute;
	}

	
	public String getAttributeName() {
	
		return attributeName;
	}

	
	public void setAttributeName(String attributeName) {
	
		this.attributeName = attributeName;
	}

	public boolean isExported() {
		return exported;
	}

	public void setExported(boolean exported) {
		this.exported = exported;
	}

	public String getXsdElementName() {
		return xsdElementName;
	}

	public void setXsdElementName(String xsdElementName) {
		this.xsdElementName = xsdElementName;
	}

	public boolean isDependsOn() {
		return dependsOn;
	}

	public void setDependsOn(boolean dependsOn) {
		this.dependsOn = dependsOn;
	}

	public String getDependencySourceName() {
		return dependencySourceName;
	}

	public void setDependencySourceName(String dependencySourceName) {
		this.dependencySourceName = dependencySourceName;
	}

	public String getDependencyFieldName() {
		return dependencyFieldName;
	}

	public void setDependencyFieldName(String dependencyFieldName) {
		this.dependencyFieldName = dependencyFieldName;
	}
}
