/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.oauth2.modules.foreground;

import com.imcode.entities.User;
import com.imcode.oeplatform.oauth2.modules.foreground.ByNameGroupPopulator;
import com.imcode.oeplatform.oauth2.modules.foreground.IvisOAuth2User;
import com.imcode.oeplatform.oauth2.modules.foreground.IvisUserPopulator;
import com.imcode.services.UserService;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.ProxyIvisServiceFactoryBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.GroupMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.SimpleProviderDescriptor;
import se.unlogic.hierarchy.core.enums.EventTarget;
import se.unlogic.hierarchy.core.handlers.GroupHandler;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.LoginProvider;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.interfaces.ProviderDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.login.LoginEvent;
import se.unlogic.hierarchy.foregroundmodules.userproviders.SimpleUser;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.NonNegativeStringIntegerValidator;
import se.unlogic.standardutils.validation.PositiveStringIntegerValidator;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;

public class OAuth2LoginProviderModule
extends AnnotatedForegroundModule
implements LoginProvider {
    private static final String CLIENT_CONTEXT_PARAM_NAME = "OAuth2ClientContext";
    private static final String ACCESS_TOKEN_REQUEST_PARAM_NAME = "OAuth2AccessTokenRequest";
    private static final String DEFAULT_ACCESS_TOKEN_PATH = "/oauth/token";
    private static final String DEFAULT_CLIENT_SCOPE_STRING = "read\nwrite";
    private static final String DEFAULT_AUTHORIZATION_PATH = "/oauth/authorize";
    private static final String SERVICE_FACTORY_NAME = "OAuth2ServiceFactory";
    private static final String DEFAULT_API_PATH = "/api/v1/json";
    private static final String ROW_SPLITER = "\n";
    private static final String PAIR_SPLITER = "[=:]";
    private static final String VALUE_SPLITER = "[,;]";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server Url", description="iVIS server url \"http://localhost:8080/ivis\"", required=true)
    protected String serverUrl;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Client id", description="iVIS client id", required=true)
    protected String clientId;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Client secret", description="iVIS secret", required=true)
    protected String clientSecret;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server access token path", description="iVIS server access token path to retrive new access token \"/oauth/token\";", required=true)
    protected String accessTokenPath = "/oauth/token";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server authorization path", description="iVIS server authorization path to retrive new authorization code \"/oauth/authorize\";", required=true)
    protected String authorizationPath = "/oauth/authorize";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server API path", description="iVIS server API path to negotiating with server \"/api/v1/json\";", required=true)
    protected String apiPath = "/api/v1/json";
    @ModuleSetting
    @TextAreaSettingDescriptor(name="Client scopeList", description="iVIS client scopeList", required=true)
    protected String clientScope = "read\nwrite";
    @ModuleSetting(id="userTimeout")
    @TextFieldSettingDescriptor(id="userTimeout", name="User session timeout", description="Session timeout for normal users (in minutes)", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected int userSessionTimeout = 30;
    @ModuleSetting(id="adminTimeout")
    @TextFieldSettingDescriptor(id="adminTimeout", name="Admin session timeout", description="Session timeout for administrators (in minutes)", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected int adminSessionTimeout = 60;
    @ModuleSetting
    @TextAreaSettingDescriptor(name="Logout module aliases", description="The aliases of the logout modules (one per line)", required=true)
    protected String logoutModuleAliases = "/logout\n/logout/logout";
    @ModuleSetting(id="default")
    @CheckboxSettingDescriptor(id="default", name="Add to login handler", description="Controls if this module should add itself to the login handler as a login provider")
    protected boolean addToLoginHandler = true;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Login provider priority", description="The priority of the login provider from this module (lower value means higher priority)", required=true, formatValidator=NonNegativeStringIntegerValidator.class)
    protected int priority = 100;
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="New password module alias", description="The full alias of the new password module", required=false)
    protected String newPasswordModuleAlias;
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="Registration module alias", description="The full alias of the registration module", required=false)
    protected String registrationModuleAlias;
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="Default redirect alias", description="The full alias that users should be redirected to after login unless a redirect paramater is present in the URL. If this value is not set and no redirect paramater is present users will be redirected to the root of the context path.", required=false)
    protected String defaultRedirectAlias;
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Role name to group name map", description="", required=false)
    protected String roleGroupString;
    @ModuleSetting(allowsNull=true)
    @GroupMultiListSettingDescriptor(name="Default groups", description="Groups would be added for default to new user")
    protected List<Integer> defaultGroupIDs = Collections.EMPTY_LIST;
    private Map<String, List<String>> groupNameMap;
    private List<String> scopeList;
    protected List<String> logoutModuleAliasesList;
    protected ProviderDescriptor providerDescriptor;
    private UserHandler userHandler;
    private GroupHandler groupHandler;
    private OAuth2ProtectedResourceDetails resource;
    private AuthorizationCodeAccessTokenProvider accessTokenProvider = new AuthorizationCodeAccessTokenProvider();

    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
    }

    private OAuth2ProtectedResourceDetails createAuthorizationCodeResourceDetails() {
        AuthorizationCodeResourceDetails resource = new AuthorizationCodeResourceDetails();
        resource.setClientId(this.clientId);
        resource.setGrantType("authorization_code");
        resource.setClientSecret(this.clientSecret);
        resource.setAccessTokenUri(this.serverUrl + this.accessTokenPath);
        resource.setScope(this.scopeList);
        resource.setUserAuthorizationUri(this.serverUrl + DEFAULT_AUTHORIZATION_PATH);
        return resource;
    }

    public boolean loginUser(HttpServletRequest req, URIParser uriParser, se.unlogic.hierarchy.core.beans.User user) throws Exception {
        return false;
    }

    protected void parseSettings(MutableSettingHandler mutableSettingHandler) throws Exception {
        super.parseSettings(mutableSettingHandler);
        this.userHandler = this.systemInterface.getUserHandler();
        this.groupHandler = this.systemInterface.getGroupHandler();
        if (this.logoutModuleAliases != null) {
            this.logoutModuleAliasesList = Arrays.asList(this.logoutModuleAliases.split(ROW_SPLITER));
        }
        if (this.addToLoginHandler) {
            this.sectionInterface.getSystemInterface().getLoginHandler().addProvider((LoginProvider)this);
        } else {
            this.sectionInterface.getSystemInterface().getLoginHandler().removeProvider((LoginProvider)this);
        }
        if (this.clientScope != null) {
            this.scopeList = Arrays.asList(this.clientScope.split(ROW_SPLITER));
            this.scopeList = this.scopeList.stream().map(String::trim).collect(Collectors.toList());
        }
        this.groupNameMap = OAuth2LoginProviderModule.mapGroups(this.roleGroupString);
    }

    private static Map<String, List<String>> mapGroups(String roleGroupString) {
        HashMap<String, List<String>> groupNameMap = new HashMap<String, List<String>>();
        if (roleGroupString != null && !roleGroupString.isEmpty()) {
            String[] pairStrings;
            for (String pairString : pairStrings = roleGroupString.split(ROW_SPLITER)) {
                String[] pair = pairString.split(PAIR_SPLITER);
                if (pair.length <= 0 || pair.length >= 3 || pair[0].trim().isEmpty()) continue;
                List values = Collections.EMPTY_LIST;
                if (pair.length > 1) {
                    values = Arrays.stream(pair[1].split(VALUE_SPLITER)).map(String::trim).collect(Collectors.toList());
                }
                groupNameMap.put(pair[0].trim(), values);
            }
        }
        return groupNameMap;
    }

    public static void main(String[] args) {
        Map<String, List<String>> m = OAuth2LoginProviderModule.mapGroups("ROLE_ADMIN=Systemadministrat\u00f6rer, Medborgare, E-tj\u00e4nst administrat\u00f6rer\nROLE_DEVELOPER=E-tj\u00e4nst administrat\u00f6rer\n\nasdfasdf\n\n=\nROLE_USER = User");
        System.out.println(m);
    }

    protected void redirectUser(UserRedirectRequiredException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUri = e.getRedirectUri();
        StringBuilder builder = new StringBuilder(redirectUri);
        Map requestParams = e.getRequestParams();
        int appendChar = redirectUri.indexOf(63) < 0 ? 63 : 38;
        for (Map.Entry param : requestParams.entrySet()) {
            try {
                builder.append((char)appendChar).append((String)param.getKey()).append('=').append(URLEncoder.encode((String)param.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException(uee);
            }
            appendChar = 38;
        }
        if (e.getStateKey() != null) {
            builder.append((char)appendChar).append("state").append('=').append(e.getStateKey());
        }
        new DefaultRedirectStrategy().sendRedirect(request, response, builder.toString());
    }

    public OAuth2AccessToken getAccessToken(OAuth2ClientContext context) throws UserRedirectRequiredException {
        OAuth2AccessToken accessToken = context.getAccessToken();
        if (accessToken == null || accessToken.isExpired()) {
            try {
                accessToken = this.acquireAccessToken(context);
            }
            catch (UserRedirectRequiredException e) {
                context.setAccessToken(null);
                accessToken = null;
                String stateKey = e.getStateKey();
                if (stateKey != null) {
                    Object stateToPreserve = e.getStateToPreserve();
                    if (stateToPreserve == null) {
                        stateToPreserve = "NONE";
                    }
                    context.setPreservedState(stateKey, stateToPreserve);
                }
                throw e;
            }
        }
        return accessToken;
    }

    protected OAuth2AccessToken acquireAccessToken(OAuth2ClientContext oauth2Context) throws UserRedirectRequiredException {
        OAuth2AccessToken existingToken;
        AccessTokenRequest accessTokenRequest = oauth2Context.getAccessTokenRequest();
        if (accessTokenRequest == null) {
            throw new AccessTokenRequiredException("No OAuth 2 security context has been established. Unable to access resource '" + this.resource.getId() + "'.", this.resource);
        }
        String stateKey = accessTokenRequest.getStateKey();
        if (stateKey != null) {
            accessTokenRequest.setPreservedState(oauth2Context.removePreservedState(stateKey));
        }
        if ((existingToken = oauth2Context.getAccessToken()) != null) {
            accessTokenRequest.setExistingToken(existingToken);
        }
        OAuth2AccessToken accessToken = null;
        accessToken = this.accessTokenProvider.obtainAccessToken(this.resource, accessTokenRequest);
        if (accessToken == null || accessToken.getValue() == null) {
            throw new IllegalStateException("Access token provider returned a null access token, which is illegal according to the contract.");
        }
        oauth2Context.setAccessToken(accessToken);
        return accessToken;
    }

    public SimpleForegroundModuleResponse processRequest(HttpServletRequest req, HttpServletResponse res, se.unlogic.hierarchy.core.beans.User user, URIParser uriParser) throws Exception {
        try {
            OAuth2ClientContext clientContext = this.getClientContext(req);
            this.getAccessToken(clientContext);
            IvisServiceFactory factory = this.createIvisServiceFactory(clientContext);
            UserService ivisUserService = (UserService)factory.getService(UserService.class);
            User ivisUser = ivisUserService.getCurrentUser();
            if (ivisUser != null) {
                IvisOAuth2User<se.unlogic.hierarchy.core.beans.User> oAuth2User = null;
                se.unlogic.hierarchy.core.beans.User hierachyUser = this.userHandler.getUserByAttribute("ivisUserId", ((Long)ivisUser.getId()).toString(), true, true);
                if (hierachyUser == null) {
                    SimpleUser newHierachyUser = new SimpleUser();
                    hierachyUser = newHierachyUser;
                    oAuth2User = new IvisOAuth2User<se.unlogic.hierarchy.core.beans.User>(hierachyUser, factory);
                    Set defaultGroupSet = this.defaultGroupIDs != null ? new LinkedHashSet(this.groupHandler.getGroups(this.defaultGroupIDs, false)) : Collections.EMPTY_SET;
                    ByNameGroupPopulator groupPupulator = new ByNameGroupPopulator(this.groupHandler, this.groupNameMap, defaultGroupSet);
                    IvisUserPopulator userPopulator = new IvisUserPopulator(groupPupulator);
                    userPopulator.populate(oAuth2User, ivisUser);
                    this.userHandler.addUser(hierachyUser);
                } else {
                    oAuth2User = new IvisOAuth2User<se.unlogic.hierarchy.core.beans.User>(hierachyUser, factory);
                }
                if (oAuth2User.isEnabled()) {
                    this.setLoggedIn(req, uriParser, oAuth2User);
                    return this.sendRedirect(req, res, uriParser, oAuth2User);
                }
                this.log.warn((Object)("Login refused for user " + oAuth2User + " (account disabled) accessing from address " + req.getRemoteHost()));
                Document doc = this.createDocument(req, uriParser);
                doc.getDocumentElement().appendChild(doc.createElement("AccountDisabled"));
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), new Breadcrumb[]{this.getDefaultBreadcrumb()});
            }
        }
        catch (UserRedirectRequiredException e) {
            this.redirectUser(e, req, res);
        }
        return new SimpleForegroundModuleResponse("\u041e\u0419, \u0427\u0442\u043e-\u0442\u043e \u0441\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c!!! :(", new Breadcrumb[0]);
    }

    private IvisServiceFactory createIvisServiceFactory(OAuth2ClientContext clientContext) {
        ProxyIvisServiceFactoryBuilder builder = new ProxyIvisServiceFactoryBuilder();
        builder.setApiUrl(this.serverUrl + this.apiPath).setClientContext(clientContext).setClient(this.resource);
        return builder.build();
    }

    private OAuth2ClientContext getClientContext(HttpServletRequest req) {
        OAuth2ClientContext clientContext = null;
        HttpSession session = req.getSession();
        Object value = session.getAttribute(CLIENT_CONTEXT_PARAM_NAME);
        AccessTokenRequest accessTokenRequest = this.getAccessTokenRequest(req);
        if (value instanceof OAuth2ClientContext) {
            clientContext = (OAuth2ClientContext)value;
        } else {
            clientContext = new DefaultOAuth2ClientContext(accessTokenRequest);
            session.setAttribute(CLIENT_CONTEXT_PARAM_NAME, (Object)clientContext);
        }
        AccessTokenRequest contextRequest = clientContext.getAccessTokenRequest();
        contextRequest.clear();
        HashMap params = new HashMap();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            params.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        contextRequest.putAll(params);
        contextRequest.setCurrentUri(accessTokenRequest.getCurrentUri());
        return clientContext;
    }

    private AccessTokenRequest getAccessTokenRequest(HttpServletRequest req) {
        Object value = req.getAttribute(ACCESS_TOKEN_REQUEST_PARAM_NAME);
        if (value instanceof AccessTokenRequest) {
            return (AccessTokenRequest)value;
        }
        DefaultAccessTokenRequest accessTokenRequest = new DefaultAccessTokenRequest(req.getParameterMap());
        String currentUrl = this.calculateCurrentUri(req);
        accessTokenRequest.setCurrentUri(currentUrl);
        req.setAttribute(ACCESS_TOKEN_REQUEST_PARAM_NAME, (Object)accessTokenRequest);
        return accessTokenRequest;
    }

    public void setLoggedIn(HttpServletRequest req, URIParser uriParser, se.unlogic.hierarchy.core.beans.User loginUser) throws Exception {
        HttpSession session = req.getSession(true);
        session.setAttribute("user", (Object)loginUser);
        session.removeAttribute("usedRetries");
        session.removeAttribute(CLIENT_CONTEXT_PARAM_NAME);
        req.removeAttribute(ACCESS_TOKEN_REQUEST_PARAM_NAME);
        if (loginUser.isAdmin()) {
            session.setMaxInactiveInterval(this.adminSessionTimeout * 60);
        } else {
            session.setMaxInactiveInterval(this.userSessionTimeout * 60);
        }
        this.log.info((Object)("User " + loginUser + " logged in from address " + req.getRemoteHost()));
        this.systemInterface.getEventHandler().sendEvent(se.unlogic.hierarchy.core.beans.User.class, (Serializable)new LoginEvent(loginUser, session), EventTarget.ALL);
    }

    public SimpleForegroundModuleResponse sendRedirect(HttpServletRequest req, HttpServletResponse res, URIParser uriParser, se.unlogic.hierarchy.core.beans.User loginUser) throws Exception {
        String redirectUrl = this.getRedirectUri(req);
        if (redirectUrl != null) {
            res.sendRedirect(redirectUrl);
        }
        return null;
    }

    protected String calculateCurrentUri(HttpServletRequest request) {
        boolean legalSpaces;
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        String queryString = request.getQueryString();
        boolean bl = legalSpaces = queryString != null && queryString.contains("+");
        if (legalSpaces) {
            builder.replaceQuery(queryString.replace("+", "%20"));
        }
        UriComponents uri = null;
        try {
            uri = builder.replaceQueryParam("code", new Object[0]).build(true);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        String query = uri.getQuery();
        if (legalSpaces) {
            query = query.replace("%20", "+");
        }
        return ServletUriComponentsBuilder.fromUri((URI)uri.toUri()).replaceQuery(query).build().toString();
    }

    private String getRedirectUri(HttpServletRequest req) {
        String redirectParam = null;
        try {
            redirectParam = URLDecoder.decode(req.getParameter("redirect"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (redirectParam != null && redirectParam.startsWith("/")) {
            return req.getContextPath() + redirectParam;
        }
        if (this.defaultRedirectAlias != null) {
            return req.getContextPath() + this.defaultRedirectAlias;
        }
        if (StringUtils.isEmpty((String)req.getContextPath())) {
            return "/";
        }
        return req.getContextPath();
    }

    protected Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("document");
        doc.appendChild(document);
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)document, (String)"newPasswordModuleAlias", (String)this.newPasswordModuleAlias);
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)document, (String)"registrationModuleAlias", (String)this.registrationModuleAlias);
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)document, (String)"uri", (String)(req.getContextPath() + uriParser.getFormattedURI()));
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)document, (String)"redirect", (String)req.getParameter("redirect"));
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)document, (String)"contextpath", (String)req.getContextPath());
        return doc;
    }

    public int getPriority() {
        return this.priority;
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res, URIParser uriParser, String redirectURI) throws Throwable {
        if (redirectURI != null) {
            res.sendRedirect(this.getModuleURI(req) + "?redirect=" + URLEncoder.encode(redirectURI, "ISO-8859-1"));
        } else {
            this.redirectToDefaultMethod(req, res);
        }
    }

    protected void moduleConfigured() throws Exception {
        this.providerDescriptor = new SimpleProviderDescriptor((ModuleDescriptor)this.moduleDescriptor);
        this.resource = this.createAuthorizationCodeResourceDetails();
    }

    public void unload() throws Exception {
        this.sectionInterface.getSystemInterface().getLoginHandler().removeProvider((LoginProvider)this);
        super.unload();
    }

    public ForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, se.unlogic.hierarchy.core.beans.User user, URIParser uriParser) throws Exception {
        return this.processRequest(req, res, user, uriParser);
    }

    public ProviderDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public boolean supportsRequest(HttpServletRequest req, URIParser uriParser) throws Throwable {
        return true;
    }
}

