/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.textfieldquery2;

import com.imcode.oeplatform.flowengine.interfaces.MultiValueQueryInstance;
import com.imcode.oeplatform.flowengine.queries.DependentQueryInstance;
import com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextFieldQuery;
import com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextFieldValue;
import com.nordicpeak.flowengine.interfaces.QueryHandler;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryInstance;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLUtils;

@Table(name="ivis_label_field_query_instances")
@XMLElement
public class TextFieldQueryInstance
extends BaseQueryInstance
implements DependentQueryInstance,
MultiValueQueryInstance {
    private static final long serialVersionUID = -7761759005604863873L;
    public static Field VALUES_RELATION = ReflectionUtils.getField(TextFieldQueryInstance.class, (String)"values");
    public static Field QUERY_RELATION = ReflectionUtils.getField(TextFieldQueryInstance.class, (String)"query");
    @DAOManaged
    @Key
    @XMLElement
    private Integer queryInstanceID;
    @DAOManaged(columnName="queryID")
    @ManyToOne
    @XMLElement
    private TextFieldQuery query;
    @DAOManaged
    @OneToMany
    @XMLElement(fixCase=true)
    private List<TextFieldValue> values = new ArrayList<TextFieldValue>();

    public Integer getQueryInstanceID() {
        return this.queryInstanceID;
    }

    public void setQueryInstanceID(Integer queryInstanceID) {
        this.queryInstanceID = queryInstanceID;
    }

    @Override
    public TextFieldQuery getQuery() {
        return this.query;
    }

    public void setQuery(TextFieldQuery query) {
        this.query = query;
    }

    public String toString() {
        return "TextFieldQueryQueryInstance (queryInstanceID=" + this.queryInstanceID + ")";
    }

    public void reset(MutableAttributeHandler attributeHandler) {
        if (this.values != null) {
            for (TextFieldValue textFieldValue : this.values) {
                if (!textFieldValue.getTextField().isSetAsAttribute()) continue;
                attributeHandler.removeAttribute(textFieldValue.getTextField().getAttributeName());
            }
        }
        this.values = null;
        super.reset(attributeHandler);
    }

    public List<TextFieldValue> getValues() {
        return this.values;
    }

    public void setValues(List<TextFieldValue> values) {
        this.values = values;
    }

    public String getFieldValue(String label) {
        if (this.values != null) {
            for (TextFieldValue textFieldValue : this.values) {
                if (!textFieldValue.getTextField().getLabel().equals(label)) continue;
                return textFieldValue.getValue();
            }
        }
        return null;
    }

    public Element toExportXML(Document doc, QueryHandler queryHandler) throws Exception {
        Element element = this.getBaseExportXML(doc);
        if (this.values != null) {
            ArrayList<String> fieldElementNames = new ArrayList<String>(this.values.size());
            for (TextFieldValue textFieldValue : this.values) {
                XMLUtils.appendNewCDATAElement((Document)doc, (Element)element, (String)TextFieldQuery.generateElementName(textFieldValue.getTextField().getLabel(), fieldElementNames), (String)textFieldValue.getValue());
            }
        }
        return element;
    }
}

