/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.textfieldquery;

import com.imcode.oeplatform.flowengine.queries.textfieldquery.FieldLayout;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextField;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQuery;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQueryProviderModule;
import com.nordicpeak.flowengine.beans.QueryDescriptor;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUD;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUDCallback;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.enums.CRUDAction;
import se.unlogic.hierarchy.core.enums.EventTarget;
import se.unlogic.hierarchy.core.events.CRUDEvent;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.URIParser;

public class TextFieldQueryCRUD
extends BaseQueryCRUD<TextFieldQuery, TextFieldQueryProviderModule> {
    protected AnnotatedDAOWrapper<TextFieldQuery, Integer> queryDAO;

    public TextFieldQueryCRUD(AnnotatedDAOWrapper<TextFieldQuery, Integer> queryDAO, BeanRequestPopulator<TextFieldQuery> populator, String typeElementName, String typeLogName, String listMethodAlias, TextFieldQueryProviderModule callback) {
        super(TextFieldQuery.class, queryDAO, populator, typeElementName, typeLogName, listMethodAlias, (BaseQueryCRUDCallback)callback);
        this.queryDAO = queryDAO;
    }

    public ForegroundModuleResponse sort(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        TextFieldQuery query = (TextFieldQuery)this.getRequestedBean(req, res, user, uriParser, "update");
        if (query != null) {
            List<TextField> textFields;
            this.checkUpdateAccess(query, user, req, uriParser);
            if (req.getMethod().equalsIgnoreCase("POST") && !CollectionUtils.isEmpty(textFields = query.getFields())) {
                for (TextField textField : textFields) {
                    String sortIndex = req.getParameter("sortorder_" + textField.getTextFieldID());
                    if (!NumberUtils.isInt((String)sortIndex)) continue;
                    textField.setSortIndex(NumberUtils.toInt((String)sortIndex));
                }
                this.queryDAO.update((Object)query);
                ((TextFieldQueryProviderModule)this.callback).getEventHandler().sendEvent(QueryDescriptor.class, (Serializable)new CRUDEvent(CRUDAction.UPDATE, (Serializable)((QueryDescriptor)query.getQueryDescriptor())), EventTarget.ALL);
                ((TextFieldQueryProviderModule)this.callback).redirectToQueryConfig(query, req, res);
                return null;
            }
            Document doc = ((TextFieldQueryProviderModule)this.callback).createDocument(req, uriParser, user);
            Element updateTypeElement = doc.createElement("SortTextFields");
            doc.getFirstChild().appendChild(updateTypeElement);
            updateTypeElement.appendChild(query.toXML(doc));
            return new SimpleForegroundModuleResponse(doc, new Breadcrumb[0]);
        }
        throw new URINotFoundException(uriParser);
    }

    protected TextFieldQuery populateFromUpdateRequest(TextFieldQuery bean, HttpServletRequest req, User user, URIParser uriParser) throws ValidationException, Exception {
        TextFieldQuery query = (TextFieldQuery)super.populateFromUpdateRequest((Elementable)bean, req, user, uriParser);
        ArrayList validationErrors = new ArrayList();
        this.populateQueryDescriptor((QueryDescriptor)query.getQueryDescriptor(), req, validationErrors);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        return query;
    }

    protected void appendShowFormData(TextFieldQuery bean, Document doc, Element showTypeElement, User user, HttpServletRequest req, HttpServletResponse res, URIParser uriParser) throws SQLException, IOException, Exception {
        XMLUtils.appendNewElement((Document)doc, (Element)showTypeElement, (String)"showFlowURL", (String)((TextFieldQueryProviderModule)this.callback).getFlowAdminModule().getFlowQueryRedirectURL(req, bean.getQueryDescriptor().getStep().getFlow().getFlowID().intValue()));
        this.appendFieldLayouts(doc, showTypeElement);
    }

    protected void appendUpdateFormData(TextFieldQuery bean, Document doc, Element updateTypeElement, User user, HttpServletRequest req, URIParser uriParser) throws Exception {
        this.appendFieldLayouts(doc, updateTypeElement);
    }

    protected ForegroundModuleResponse beanUpdated(TextFieldQuery bean, HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        ((TextFieldQueryProviderModule)this.callback).getEventHandler().sendEvent(QueryDescriptor.class, (Serializable)new CRUDEvent(CRUDAction.UPDATE, (Serializable)((QueryDescriptor)bean.getQueryDescriptor())), EventTarget.ALL);
        ((TextFieldQueryProviderModule)this.callback).redirectToQueryConfig(bean, req, res);
        return null;
    }

    protected List<Field> getBeanRelations() {
        return Arrays.asList(TextFieldQuery.TEXT_FIELDS_RELATION);
    }

    protected void appendFieldLayouts(Document doc, Element element) {
        for (FieldLayout layout : FieldLayout.values()) {
            Element fieldLayoutElement = doc.createElement("FieldLayout");
            element.appendChild(fieldLayoutElement);
            XMLUtils.appendNewElement((Document)doc, (Element)fieldLayoutElement, (String)"name", (String)((TextFieldQueryProviderModule)this.callback).getFieldLayoutName(layout));
            XMLUtils.appendNewElement((Document)doc, (Element)fieldLayoutElement, (String)"value", (Object)((Object)layout));
        }
    }
}

