/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.linked.dropdownquery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.oeplatform.flowengine.populators.dao.DaoPopulator;
import com.imcode.oeplatform.flowengine.populators.dao.DaoPopulatorFactory;
import com.imcode.oeplatform.flowengine.populators.entity.application.ApplicationPopulator;
import com.imcode.oeplatform.flowengine.populators.query.LabelFieldQueryInstanceValueBinder;
import com.imcode.oeplatform.flowengine.populators.query.TextAreaQueryInstanceValueBinder;
import com.imcode.oeplatform.flowengine.populators.query.TextFieldQueryInstanceValueBinder;
import com.imcode.oeplatform.flowengine.populators.query.ValueBinder;
import com.imcode.oeplatform.flowengine.queries.linked.dropdownquery.LinkedDropDownAlternative;
import com.imcode.oeplatform.flowengine.queries.linked.dropdownquery.LinkedDropDownQuery;
import com.imcode.oeplatform.flowengine.queries.linked.dropdownquery.LinkedDropDownQueryCRUD;
import com.imcode.oeplatform.flowengine.queries.linked.dropdownquery.LinkedDropDownQueryInstance;
import com.imcode.oeplatform.flowengine.queries.linked.linkedalternativesquery.LinkedAlternativeQueryUtils;
import com.imcode.oeplatform.flowengine.queries.linked.linkedalternativesquery.LinkedAlternativesQueryCallback;
import com.imcode.oeplatform.oauth2.modules.foreground.IvisOAuth2User;
import com.imcode.oeplatform.oauth2.utils.OAuth2Utils;
import com.imcode.services.GenericService;
import com.imcode.services.PupilService;
import com.nordicpeak.flowengine.enums.QueryState;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.InstanceMetadata;
import com.nordicpeak.flowengine.interfaces.MutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.MutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.Query;
import com.nordicpeak.flowengine.interfaces.QueryInstance;
import com.nordicpeak.flowengine.managers.MutableFlowInstanceManager;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUDCallback;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryInstance;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryProviderModule;
import com.nordicpeak.flowengine.queries.tablequery.SummaryTableQueryCallback;
import com.nordicpeak.flowengine.utils.JTidyUtils;
import com.nordicpeak.flowengine.utils.TextTagReplacer;
import imcode.services.IvisServiceFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.PasswordSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.utils.FCKUtils;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfile;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.datatypes.Matrix;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLGenerator;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;
import se.unlogic.webutils.url.URLRewriter;

public class LinkedDropDownQueryProviderModule
extends BaseQueryProviderModule<LinkedDropDownQueryInstance>
implements BaseQueryCRUDCallback,
LinkedAlternativesQueryCallback<LinkedDropDownQuery>,
SummaryTableQueryCallback<LinkedDropDownQuery> {
    private static final String DEFAULT_CLIENT_SCOPE_STRING = "read\nwrite";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server Url", description="iVIS server url \"http://localhost:8080/ivis\"", required=true)
    protected String serverUrl;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Client id", description="iVIS client id", required=true)
    protected String clientId;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Client secret", description="iVIS secret", required=true)
    protected String clientSecret;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server access token path", description="iVIS server access token path to retrive new access token \"/oauth/token\";", required=true)
    protected String accessTokenPath = "/oauth/token";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server API path", description="iVIS server API path to negotiating with server \"/api/v1/json\";", required=true)
    protected String apiPath = "/api/v1/json";
    @ModuleSetting
    @TextAreaSettingDescriptor(name="Client scopeList", description="iVIS client scopeList", required=true)
    protected String clientScope = "read\nwrite";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server username", description="iVIS server username to retrive access token", required=true)
    protected String username;
    @ModuleSetting
    @PasswordSettingDescriptor(name="Server password", description="iVIS server user password", required=true)
    protected String password;
    private transient IvisServiceFactory serviceFactory;
    private AnnotatedDAO<LinkedDropDownQuery> queryDAO;
    private AnnotatedDAO<LinkedDropDownQueryInstance> queryInstanceDAO;
    private LinkedDropDownQueryCRUD queryCRUD;
    private QueryParameterFactory<LinkedDropDownQuery, Integer> queryIDParamFactory;
    private QueryParameterFactory<LinkedDropDownQueryInstance, Integer> queryInstanceIDParamFactory;
    private QueryParameterFactory<LinkedDropDownQueryInstance, LinkedDropDownQuery> queryInstanceQueryParamFactory;

    protected synchronized void moduleConfigured() throws Exception {
        super.moduleConfigured();
        OAuth2ProtectedResourceDetails resource = OAuth2Utils.createPsswordResourceDetails(this.clientId, this.clientSecret, this.serverUrl + this.accessTokenPath, Arrays.asList(this.clientScope.split("\\s+")), this.username, this.password);
        this.serviceFactory = OAuth2Utils.createIvisServiceFactory(this.serverUrl + this.apiPath, resource);
    }

    protected void createDAOs(DataSource dataSource) throws Exception {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)LinkedDropDownQueryProviderModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(this.getClass().getResourceAsStream("DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        SimpleAnnotatedDAOFactory daoFactory = new SimpleAnnotatedDAOFactory(dataSource);
        Function<String, Class> classNameParser = s -> {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class not found", e);
            }
        };
        DaoPopulator<Class> classDaoPopulator = DaoPopulatorFactory.get(Class.class, classNameParser, o -> ((Class)o).getName());
        daoFactory.addBeanStringPopulator(classDaoPopulator);
        daoFactory.addQueryParameterPopulator(classDaoPopulator);
        DaoPopulator<LinkedDropDownAlternative> alternativePopulator = DaoPopulatorFactory.get(LinkedDropDownAlternative.class);
        daoFactory.addBeanStringPopulator(alternativePopulator);
        daoFactory.addQueryParameterPopulator(alternativePopulator);
        this.queryDAO = daoFactory.getDAO(LinkedDropDownQuery.class);
        this.queryInstanceDAO = daoFactory.getDAO(LinkedDropDownQueryInstance.class);
        this.queryCRUD = new LinkedDropDownQueryCRUD((AnnotatedDAOWrapper<LinkedDropDownQuery, Integer>)this.queryDAO.getWrapper(Integer.class), (BeanRequestPopulator<LinkedDropDownQuery>)new AnnotatedRequestPopulator(LinkedDropDownQuery.class), "LinkedDropDownQuery", "query", null, this);
        this.queryIDParamFactory = this.queryDAO.getParamFactory("queryID", Integer.class);
        this.queryInstanceIDParamFactory = this.queryInstanceDAO.getParamFactory("queryInstanceID", Integer.class);
        this.queryInstanceQueryParamFactory = this.queryInstanceDAO.getParamFactory("query", LinkedDropDownQuery.class);
    }

    public Query createQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        LinkedDropDownQuery query = new LinkedDropDownQuery();
        query.setQueryID(descriptor.getQueryID());
        this.queryDAO.add((Object)query, transactionHandler, null);
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor) throws SQLException {
        LinkedDropDownQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        LinkedDropDownQuery query = this.getQuery(descriptor.getQueryID(), transactionHandler);
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    private LinkedDropDownQueryInstance getQueryInstance(Integer queryInstanceID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{LinkedDropDownQueryInstance.QUERY_RELATION});
        query.addParameter(this.queryInstanceIDParamFactory.getParameter((Object)queryInstanceID));
        return (LinkedDropDownQueryInstance)this.queryInstanceDAO.get(query);
    }

    public Query importQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        LinkedDropDownQuery query = new LinkedDropDownQuery();
        query.setQueryID(descriptor.getQueryID());
        query.populate(descriptor.getImportParser().getNode(XMLGenerator.getElementName(query.getClass())));
        List<? extends Serializable> oldAlternativeIDs = LinkedAlternativeQueryUtils.getAlternativeIDs(query);
        LinkedAlternativeQueryUtils.clearAlternativeIDs(query.getAlternatives());
        this.queryDAO.add((Object)query, transactionHandler, null);
        return query;
    }

    protected void initQuery(LinkedDropDownQuery query, IvisServiceFactory factory) {
        Class<?> clazz;
        String entityClassname = query.getEntityClassname();
        try {
            clazz = Class.forName(entityClassname);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot parse entity class for name \"" + entityClassname + "\""), (Throwable)e);
            return;
        }
        GenericService entityService = factory.getServiceFor(clazz);
        query.setEntityService(entityService);
        List allEntities = entityService.findAll();
        List<LinkedDropDownAlternative> alternatives = allEntities.stream().map(entity -> new LinkedDropDownAlternative((Long)entity.getId(), entity.toString())).collect(Collectors.toList());
        query.setAlternatives(alternatives);
        query.setEntities(allEntities);
    }

    public QueryInstance getQueryInstance(MutableQueryInstanceDescriptor descriptor, String instanceManagerID, HttpServletRequest req, User user, InstanceMetadata instanceMetadata) throws SQLException {
        IvisOAuth2User ivisUser;
        IvisServiceFactory factory;
        LinkedDropDownQueryInstance queryInstance;
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance = new LinkedDropDownQueryInstance();
        } else {
            queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
            if (queryInstance == null) {
                return null;
            }
        }
        LinkedDropDownQuery query = this.getQuery(descriptor.getQueryDescriptor().getQueryID());
        if (user instanceof IvisOAuth2User && (factory = (ivisUser = (IvisOAuth2User)user).getServiceFactory()) != null) {
            this.initQuery(query, factory);
        }
        queryInstance.setQuery(query);
        if (queryInstance.getQuery() == null) {
            return null;
        }
        if (req != null) {
            FCKUtils.setAbsoluteFileUrls((Object)queryInstance.getQuery(), (String)(RequestUtils.getFullContextPathURL((HttpServletRequest)req) + this.ckConnectorModuleAlias));
            URLRewriter.setAbsoluteLinkUrls((Object)queryInstance.getQuery(), (HttpServletRequest)req, (boolean)true);
        }
        TextTagReplacer.replaceTextTags((Object)queryInstance.getQuery(), (SiteProfile)instanceMetadata.getSiteProfile());
        queryInstance.set(descriptor);
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance.copyQueryValues();
        }
        return queryInstance;
    }

    public LinkedDropDownQuery getQuery(Integer queryID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{LinkedDropDownQuery.ALTERNATIVES_RELATION});
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        LinkedDropDownQuery linkedQuery = (LinkedDropDownQuery)this.queryDAO.get(query);
        return linkedQuery;
    }

    public LinkedDropDownQuery getQuery(Integer queryID, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{LinkedDropDownQuery.ALTERNATIVES_RELATION});
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        LinkedDropDownQuery linkedQuery = (LinkedDropDownQuery)this.queryDAO.get(query, transactionHandler);
        return linkedQuery;
    }

    public void save(LinkedDropDownQueryInstance queryInstance, TransactionHandler transactionHandler) throws Throwable {
        if (queryInstance.getQueryInstanceID() == null || !queryInstance.getQueryInstanceID().equals(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID())) {
            queryInstance.setQueryInstanceID(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID());
            this.queryInstanceDAO.add((Object)queryInstance, transactionHandler, null);
        } else {
            this.queryInstanceDAO.update((Object)queryInstance, transactionHandler, null);
        }
    }

    public void populate(LinkedDropDownQueryInstance queryInstance, HttpServletRequest req, User user, boolean allowPartialPopulation, MutableAttributeHandler attributeHandler) throws ValidationException {
        List<LinkedDropDownAlternative> availableAlternatives = queryInstance.getQuery().getAlternatives();
        if (CollectionUtils.isEmpty(availableAlternatives)) {
            queryInstance.reset(attributeHandler);
            return;
        }
        Integer alternativeID = NumberUtils.toInt((String)req.getParameter("q" + queryInstance.getQuery().getQueryID() + "_alternative"));
        boolean alternativeSelected = false;
        LinkedDropDownAlternative selectedAlternative = null;
        if (alternativeID != null) {
            for (LinkedDropDownAlternative alternative : availableAlternatives) {
                if (!alternative.getAlternativeID().equals(alternativeID)) continue;
                selectedAlternative = alternative;
                alternativeSelected = true;
                break;
            }
        }
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (allowPartialPopulation) {
            queryInstance.setAlternative(selectedAlternative);
            queryInstance.getQueryInstanceDescriptor().setPopulated(selectedAlternative != null);
            return;
        }
        if (queryInstance.getQueryInstanceDescriptor().getQueryState() == QueryState.VISIBLE_REQUIRED && !alternativeSelected) {
            validationErrors.add(new ValidationError("RequiredQuery"));
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        queryInstance.setAlternative(selectedAlternative);
        queryInstance.getQueryInstanceDescriptor().setPopulated(selectedAlternative != null);
    }

    @WebPublic(alias="update")
    public ForegroundModuleResponse setValue(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Long entityId;
        Integer queryId;
        Integer flowInstanceID = NumberUtils.toInt((String)uriParser.get(4));
        if (uriParser.size() == 5 && (queryId = NumberUtils.toInt((String)uriParser.get(2))) != null && (entityId = NumberUtils.toLong((String)uriParser.get(3))) != null) {
            MutableFlowInstanceManager instanceManager;
            List queryInstanceList;
            Optional<QueryInstance> queryInstance;
            HttpSession session = req.getSession(true);
            Pattern pattern = Pattern.compile("FlowInstance:\\d+:" + flowInstanceID);
            Optional<String> flowInstanceName = Collections.list(session.getAttributeNames()).stream().filter(pattern.asPredicate()).findFirst();
            if (flowInstanceName.isPresent() && (queryInstance = (queryInstanceList = (instanceManager = (MutableFlowInstanceManager)session.getAttribute(flowInstanceName.get())).getQueries(QueryInstance.class)).stream().filter(new QueryIdPredicate<Integer>(queryId)).findFirst()).isPresent()) {
                LinkedDropDownQueryInstance leadingQueryInstance = (LinkedDropDownQueryInstance)queryInstance.get();
                LinkedDropDownQuery linkedDropDownQuery = leadingQueryInstance.getQuery();
                ImmutableQueryDescriptor leadingQueryDescriptor = LinkedDropDownQueryProviderModule.getQueryDescriptor(leadingQueryInstance);
                if (leadingQueryDescriptor != null && linkedDropDownQuery != null) {
                    Optional<JpaEntity> entityOptional;
                    String leadingQueryXsdName = leadingQueryDescriptor.getXSDElementName();
                    List<JpaEntity> entityList = linkedDropDownQuery.getEntities();
                    if (!StringUtils.isEmpty((String)leadingQueryXsdName) && entityList != null && (entityOptional = entityList.stream().filter(jpaEntity -> entityId.equals(jpaEntity.getId())).findFirst()).isPresent()) {
                        ValueBinder valueBinder = new ValueBinder().addBinder(new TextAreaQueryInstanceValueBinder(entityOptional.get(), leadingQueryXsdName)).addBinder(new TextFieldQueryInstanceValueBinder(entityOptional.get(), leadingQueryXsdName)).addBinder(new LabelFieldQueryInstanceValueBinder(entityOptional.get(), leadingQueryXsdName));
                        queryInstanceList.stream().forEach(valueBinder::bindValues);
                        ObjectMapper mapper = new ObjectMapper();
                        String objString = mapper.writeValueAsString((Object)entityOptional.get());
                        return new SimpleForegroundModuleResponse(objString, new Breadcrumb[0]);
                    }
                }
            }
        }
        return new SimpleForegroundModuleResponse("{}", new Breadcrumb[0]);
    }

    private static ImmutableQueryDescriptor getQueryDescriptor(QueryInstance queryInstance) {
        ImmutableQueryDescriptor queryDescriptor = null;
        MutableQueryInstanceDescriptor queryInstanceDescriptor = queryInstance.getQueryInstanceDescriptor();
        if (queryInstanceDescriptor != null) {
            queryDescriptor = queryInstanceDescriptor.getQueryDescriptor();
        }
        return queryDescriptor;
    }

    @WebPublic(alias="config")
    public ForegroundModuleResponse configureQuery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.queryCRUD.update(req, res, user, uriParser);
    }

    public boolean deleteQuery(ImmutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        LinkedDropDownQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return false;
        }
        this.queryDAO.delete((Object)query, transactionHandler);
        return true;
    }

    public boolean deleteQueryInstance(ImmutableQueryInstanceDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        LinkedDropDownQueryInstance queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
        if (queryInstance == null) {
            return false;
        }
        this.queryInstanceDAO.delete((Object)queryInstance, transactionHandler);
        return true;
    }

    public String getTitlePrefix() {
        return ((ForegroundModuleDescriptor)this.moduleDescriptor).getName();
    }

    public void copyQuery(MutableQueryDescriptor sourceQueryDescriptor, MutableQueryDescriptor copyQueryDescriptor, TransactionHandler transactionHandler) throws SQLException {
        LinkedDropDownQuery query = this.getQuery(sourceQueryDescriptor.getQueryID(), transactionHandler);
        query.setQueryID(copyQueryDescriptor.getQueryID());
        this.queryDAO.add((Object)query, transactionHandler, null);
    }

    @Override
    public List<LinkedDropDownQueryInstance> getQueryInstances(LinkedDropDownQuery dropDownQuery, List<Integer> queryInstanceIDs) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.queryInstanceQueryParamFactory.getParameter((Object)dropDownQuery));
        query.addParameter(this.queryInstanceIDParamFactory.getWhereInParameter(queryInstanceIDs));
        return this.queryInstanceDAO.getAll(query);
    }

    public Matrix<String> getSummaryTable(LinkedDropDownQuery query, List<Integer> queryInstanceIDs) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void appendPDFData(Document doc, Element showQueryValuesElement, LinkedDropDownQueryInstance queryInstance) {
        super.appendPDFData(doc, showQueryValuesElement, (BaseQueryInstance)queryInstance);
        if (queryInstance.getQuery().getDescription() != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"Description", (String)JTidyUtils.getXHTML((String)queryInstance.getQuery().getDescription()));
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"isHTMLDescription", (Object)(queryInstance.getQuery().getDescription().contains("<") && queryInstance.getQuery().getDescription().contains(">") ? 1 : 0));
        }
    }

    public static void main(String[] args) {
        Path objFile = Paths.get("/home/vitaly/\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0438/obj.dat", new String[0]);
        if (!Files.exists(objFile, new LinkOption[0])) {
            System.out.println("sadfasd");
            IvisServiceFactory serviceFactory = ApplicationPopulator.remoteIvisServiceFactory();
            PupilService service = (PupilService)serviceFactory.getService(PupilService.class);
            Object object = service.find((Object)22L);
            ApplicationPopulator.saveObjectToFile(object, objFile.toString());
        }
        Object obj = ApplicationPopulator.loadObjectFromFile(objFile.toString());
        Object value = LinkedDropDownQueryProviderModule.getPropertyValue(obj);
        System.out.println(value);
    }

    private static Object getPropertyValue(Object obj) {
        BeanWrapperImpl accessor = new BeanWrapperImpl(obj);
        Object value = null;
        try {
            value = accessor.getPropertyValue("person.addresses[REGISTERED].street");
        }
        catch (BeansException ignore) {
            ignore.printStackTrace();
        }
        return value;
    }

    private static class QueryIdPredicate<T>
    implements Predicate<QueryInstance> {
        private final T id;

        public QueryIdPredicate(T id) {
            this.id = id;
        }

        @Override
        public boolean test(QueryInstance queryInstance) {
            ImmutableQueryDescriptor queryDescriptor = LinkedDropDownQueryProviderModule.getQueryDescriptor(queryInstance);
            return queryDescriptor != null && this.id.equals(queryDescriptor.getQueryID());
        }
    }

    public static class ClassPopulator
    implements BeanStringPopulator<String> {
        public String getValue(String value) {
            return value;
        }

        public Class<? extends String> getType() {
            return String.class;
        }

        public String getPopulatorID() {
            return null;
        }

        public boolean validateFormat(String value) {
            try {
                Class<?> clazz = Class.forName(value);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

