/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.checkboxquery;

import com.imcode.oeplatform.flowengine.populators.web.IvisAlternativesPopulator;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxAlternative;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQuery;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQueryProviderModule;
import com.nordicpeak.flowengine.beans.QueryDescriptor;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUD;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUDCallback;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.URIParser;

public class CheckboxQueryCRUD
extends BaseQueryCRUD<CheckboxQuery, CheckboxQueryProviderModule> {
    protected AnnotatedDAOWrapper<CheckboxQuery, Integer> queryDAO;
    protected static IvisAlternativesPopulator<CheckboxAlternative> ALTERNATIVES_POPLATOR = new IvisAlternativesPopulator<CheckboxAlternative>(CheckboxAlternative.class);

    public CheckboxQueryCRUD(AnnotatedDAOWrapper<CheckboxQuery, Integer> queryDAO, BeanRequestPopulator<CheckboxQuery> populator, String typeElementName, String typeLogName, String listMethodAlias, CheckboxQueryProviderModule callback) {
        super(CheckboxQuery.class, queryDAO, populator, typeElementName, typeLogName, listMethodAlias, (BaseQueryCRUDCallback)callback);
        this.queryDAO = queryDAO;
    }

    protected CheckboxQuery populateFromUpdateRequest(CheckboxQuery bean, HttpServletRequest req, User user, URIParser uriParser) throws ValidationException, Exception {
        List<CheckboxAlternative> alternatives;
        CheckboxQuery query = (CheckboxQuery)super.populateFromUpdateRequest((Elementable)bean, req, user, uriParser);
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        this.populateQueryDescriptor((QueryDescriptor)query.getQueryDescriptor(), req, validationErrors);
        if (req.getParameter("useFreeTextAlternative") != null && StringUtils.isEmpty((String)bean.getFreeTextAlternative())) {
            validationErrors.add(new ValidationError("freeTextAlternative", ValidationErrorType.RequiredField));
        }
        if (CollectionUtils.isEmpty(alternatives = ALTERNATIVES_POPLATOR.populate(bean.getAlternatives(), req, validationErrors))) {
            validationErrors.add(new ValidationError("ToFewAlternatives1Min"));
        } else {
            Integer minChecked = query.getMinChecked();
            Integer maxChecked = query.getMaxChecked();
            CheckboxQueryCRUD.validateMinAndMax(minChecked, maxChecked, alternatives, validationErrors);
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        query.setAlternatives(alternatives);
        return query;
    }

    public static void validateMinAndMax(Integer minChecked, Integer maxChecked, List<CheckboxAlternative> alternatives, List<ValidationError> validationErrors) {
        if (minChecked != null) {
            if (minChecked > alternatives.size()) {
                validationErrors.add(new ValidationError("MinCheckedToBig"));
            }
            if (maxChecked != null && (minChecked > maxChecked || maxChecked < minChecked)) {
                validationErrors.add(new ValidationError("MinCheckedBiggerThanMaxChecked"));
            }
        }
        if (maxChecked != null && maxChecked > alternatives.size()) {
            validationErrors.add(new ValidationError("MaxCheckedToBig"));
        }
    }

    protected List<Field> getBeanRelations() {
        return Arrays.asList(CheckboxQuery.ALTERNATIVES_RELATION);
    }
}

