/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.web;

import com.imcode.oeplatform.flowengine.interfaces.MutableFieldAlternative;
import com.nordicpeak.flowengine.interfaces.MutableAlternative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.webutils.validation.ValidationUtils;

public class IvisAlternativesPopulator<AlternativeType extends MutableFieldAlternative> {
    private Class<AlternativeType> alternativeClass;

    public IvisAlternativesPopulator(Class<AlternativeType> alternativeClass) {
        this.alternativeClass = alternativeClass;
    }

    public List<AlternativeType> populate(List<AlternativeType> currentAlternatives, HttpServletRequest req, List<ValidationError> validationErrors) {
        String[] alternativeIDs = req.getParameterValues("alternativeID");
        ArrayList<AlternativeType> alternatives = new ArrayList<AlternativeType>();
        if (alternativeIDs != null) {
            for (String alternativeID : alternativeIDs) {
                String name = ValidationUtils.validateNotEmptyParameter((String)("alternative_" + alternativeID), (HttpServletRequest)req, validationErrors);
                String sortOrder = req.getParameter("sortorder_" + alternativeID);
                boolean exported = Objects.nonNull(req.getParameter("exported_" + alternativeID));
                String xsdElementName = "";
                if (exported) {
                    xsdElementName = ValidationUtils.validateNotEmptyParameter((String)("xsdElementName_" + alternativeID), (HttpServletRequest)req, validationErrors);
                } else {
                    xsdElementName = req.getParameter("xsdElementName_" + alternativeID);
                    String string = xsdElementName = Objects.nonNull(xsdElementName) ? xsdElementName.trim() : "";
                }
                if (StringUtils.isEmpty((String)name) || !NumberUtils.isInt((String)sortOrder)) continue;
                AlternativeType alternative = this.getNewAlternativeInstance();
                alternative.setName(name);
                alternative.setSortIndex(NumberUtils.toInt((String)sortOrder));
                alternative.setExported(exported);
                alternative.setXsdElementName(xsdElementName);
                if (NumberUtils.isInt((String)alternativeID)) {
                    this.checkForExistingAlternatives(currentAlternatives, alternative, NumberUtils.toInt((String)alternativeID));
                }
                alternatives.add(alternative);
            }
        }
        return alternatives;
    }

    public List<AlternativeType> populate(XMLParser xmlParser, List<ValidationError> errors) throws ValidationException {
        List xmlParsers = xmlParser.getNodes("Alternatives/" + this.alternativeClass.getSimpleName());
        if (CollectionUtils.isEmpty((Collection)xmlParsers)) {
            errors.add(new ValidationError("NoAlternativesFound"));
            return null;
        }
        ArrayList<AlternativeType> alternatives = new ArrayList<AlternativeType>();
        for (XMLParser parser : xmlParsers) {
            AlternativeType alternative = this.getNewAlternativeInstance();
            alternative.populate(parser);
            alternatives.add(alternative);
        }
        return alternatives;
    }

    protected void checkForExistingAlternatives(List<AlternativeType> currentAlternatives, AlternativeType alternative, Integer alternativeID) {
        if (!CollectionUtils.isEmpty(currentAlternatives)) {
            for (MutableAlternative queryAlternative : currentAlternatives) {
                if (!queryAlternative.getAlternativeID().equals(alternativeID)) continue;
                alternative.setAlternativeID(alternativeID);
                break;
            }
        }
    }

    protected AlternativeType getNewAlternativeInstance() {
        try {
            return (AlternativeType)((MutableFieldAlternative)this.alternativeClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

