/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity.application;

import com.imcode.entities.interfaces.JpaEntity;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ReflectionUtils;

public class IdToEntityConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public IdToEntityConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class targetClass = targetType.getType();
        if (!JpaEntity.class.isAssignableFrom(targetClass)) {
            return false;
        }
        Method idSetter = this.getIdSetter(targetClass);
        return idSetter != null && this.conversionService.canConvert(sourceType, TypeDescriptor.valueOf(this.getEntityIdClass(targetClass)));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Class entityClass = targetType.getType();
        Method idSetter = this.getIdSetter(entityClass);
        Object id = this.conversionService.convert(source, sourceType, TypeDescriptor.valueOf(this.getEntityIdClass(entityClass)));
        Object entity = null;
        try {
            entity = entityClass.newInstance();
            ReflectionUtils.invokeMethod((Method)idSetter, entity, (Object[])new Object[]{id});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity;
    }

    protected Method getIdSetter(Class<?> entityClass) {
        Method setter = null;
        try {
            Method getter = entityClass.getMethod("getId", new Class[0]);
            setter = entityClass.getMethod("setId", getter.getReturnType());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return setter;
    }

    private Class<?> getEntityIdClass(Class<?> domainType) {
        return ResolvableType.forClass(domainType).as(JpaEntity.class).resolveGeneric(new int[]{0});
    }
}

