/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity.application;

import com.imcode.oeplatform.flowengine.populators.entity.application.ApplicationForm;
import com.imcode.oeplatform.flowengine.populators.entity.application.ApplicationFormFactory;
import com.nordicpeak.flowengine.managers.FlowInstanceManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.convert.converter.Converter;

public class FlowToPropertyValuesConverter
implements Converter<FlowInstanceManager, PropertyValues> {
    private final Map<String, String> options;

    public FlowToPropertyValuesConverter(String optionsStrting) {
        this.options = FlowToPropertyValuesConverter.mapOptions(optionsStrting);
    }

    public PropertyValues convert(FlowInstanceManager source) {
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        ApplicationForm form = new ApplicationFormFactory().createApplicationForm(source);
        for (Map.Entry<String, String> option : this.options.entrySet()) {
            String valueKey = option.getValue();
            Function<String, Object> valueExecutor = FlowToPropertyValuesConverter.isRawValue(valueKey) ? s -> s.substring(1) : s -> form.getValue((String)s);
            propertyValues.addPropertyValue(option.getKey(), valueExecutor.apply(option.getValue()));
        }
        return propertyValues;
    }

    private static boolean isListValue(String value) {
        return value.indexOf(46) < 0;
    }

    private static boolean isRawValue(String value) {
        return value.startsWith("#");
    }

    private static Map<String, String> mapOptions(String options) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (options != null && !options.isEmpty()) {
            String[] pairStrings;
            Pattern rowPattern = Pattern.compile("\n");
            Pattern pairPattern = Pattern.compile("=");
            for (String pairString : pairStrings = rowPattern.split(options)) {
                String[] pair = pairPattern.split(pairString);
                if (pair.length <= 1) continue;
                String key = pair[0].trim();
                String value = pair[1].trim();
                if (key.isEmpty() || value.isEmpty()) continue;
                map.put(key, value);
            }
        }
        return map;
    }
}

