/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity;

import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.oeplatform.flowengine.interfaces.MutableField;
import com.imcode.oeplatform.flowengine.populators.entity.FormField;
import com.imcode.oeplatform.flowengine.populators.entity.QuestionMapper;
import com.imcode.oeplatform.flowengine.populators.entity.application.BaseFormField;
import com.imcode.oeplatform.flowengine.queries.dropdownquery.DropDownQueryInstance;
import com.imcode.oeplatform.flowengine.queries.radiobuttonquery.RadioButtonQueryInstance;
import com.nordicpeak.flowengine.interfaces.ImmutableAlternative;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import com.nordicpeak.flowengine.queries.fixedalternativesquery.FixedAlternativesQueryInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class SingleAlternativeQuestionMapper
implements QuestionMapper<FixedAlternativesQueryInstance> {
    private final Predicate<ImmutableAlternative> alternativeFilter;
    private static List<Class> allowedClassList = Arrays.asList(RadioButtonQueryInstance.class, DropDownQueryInstance.class);
    private static final Predicate<ImmutableAlternative> DEFAULT_FILTER = alternative -> {
        if (alternative instanceof MutableField) {
            MutableField exportedMutableField = (MutableField)alternative;
            return exportedMutableField.isExported() && !exportedMutableField.getXsdElementName().isEmpty();
        }
        return false;
    };
    private static final Function<ImmutableAlternative, ApplicationFormQuestion> mapper = alternative -> new ApplicationFormQuestion();

    public SingleAlternativeQuestionMapper() {
        this(DEFAULT_FILTER);
    }

    public SingleAlternativeQuestionMapper(Predicate<ImmutableAlternative> alternativeFilter) {
        this.alternativeFilter = alternativeFilter;
    }

    @Override
    public Collection<ApplicationFormQuestion> getQuestions(FixedAlternativesQueryInstance queryInstance) {
        ImmutableQueryDescriptor descriptor = queryInstance.getQueryInstanceDescriptor().getQueryDescriptor();
        return new ArrayList<ApplicationFormQuestion>();
    }

    public String getValue(FixedAlternativesQueryInstance queryInstance) {
        Optional optionalValue;
        String value = null;
        List alternatives = queryInstance.getAlternatives();
        if (alternatives != null && (optionalValue = alternatives.stream().findFirst()).isPresent()) {
            value = ((ImmutableAlternative)optionalValue.get()).getName();
        }
        return value;
    }

    private String getXslElementName(ImmutableAlternative alternative) {
        if (alternative instanceof MutableField) {
            return ((MutableField)alternative).getXsdElementName();
        }
        throw new ClassCastException("Cannot cast to IvisExportedMutableField!");
    }

    @Override
    public boolean mach(Class queryClass) {
        return allowedClassList.contains(queryClass);
    }

    private FormField<ImmutableAlternative> createFormField(ImmutableAlternative field) {
        return new BaseFormField<ImmutableAlternative>(field){

            @Override
            public String getValue() {
                return ((ImmutableAlternative)this.field).getName();
            }
        };
    }
}

