/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity;

import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.entities.ApplicationFormQuestionGroup;
import com.imcode.oeplatform.flowengine.interfaces.MutableField;
import com.imcode.oeplatform.flowengine.populators.entity.FormField;
import com.imcode.oeplatform.flowengine.populators.entity.QuestionGroupMapper;
import com.imcode.oeplatform.flowengine.populators.entity.application.BaseFormField;
import com.imcode.oeplatform.flowengine.queries.dropdownquery.DropDownQueryInstance;
import com.imcode.oeplatform.flowengine.queries.radiobuttonquery.RadioButtonQueryInstance;
import com.nordicpeak.flowengine.interfaces.ImmutableAlternative;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryInstance;
import com.nordicpeak.flowengine.queries.fixedalternativesquery.FixedAlternativesQueryInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SingleAlternativeQuestionGroupMapper
extends QuestionGroupMapper<FixedAlternativesQueryInstance> {
    private final Predicate<ImmutableAlternative> alternativeFilter;
    private static List<Class> allowedClassList = Arrays.asList(RadioButtonQueryInstance.class, DropDownQueryInstance.class);
    private static final Predicate<ImmutableAlternative> DEFAULT_FILTER = alternative -> {
        if (alternative instanceof MutableField) {
            MutableField exportedMutableField = (MutableField)alternative;
            return exportedMutableField.isExported() && !exportedMutableField.getXsdElementName().isEmpty();
        }
        return false;
    };
    private static final Function<ImmutableAlternative, ApplicationFormQuestion> mapper = alternative -> new ApplicationFormQuestion();

    public SingleAlternativeQuestionGroupMapper() {
        this(DEFAULT_FILTER);
    }

    public SingleAlternativeQuestionGroupMapper(Predicate<ImmutableAlternative> alternativeFilter) {
        this.alternativeFilter = alternativeFilter;
    }

    @Override
    public void mapQuestions(ApplicationFormQuestionGroup questionGroup, FixedAlternativesQueryInstance queryInstance) {
        BaseQueryInstance instance;
        Iterator iterator;
        ImmutableQueryDescriptor descriptor = queryInstance.getQueryInstanceDescriptor().getQueryDescriptor();
        List alternatives = queryInstance.getAlternatives();
        ApplicationFormQuestion question = new ApplicationFormQuestion();
        question.setName(descriptor.getXSDElementName());
        question.setText(descriptor.getName());
        question.setMultiValues(Boolean.valueOf(false));
        question.setMultiVariants(Boolean.valueOf(true));
        question.setQuestionType(queryInstance.getClass().getName());
        if (alternatives != null && (iterator = alternatives.iterator()).hasNext()) {
            ImmutableAlternative alternative = (ImmutableAlternative)iterator.next();
            String value = alternative.getName();
            question.setValue(value);
            question.setValues(Collections.singletonList(value));
        }
        if (queryInstance instanceof RadioButtonQueryInstance) {
            instance = (RadioButtonQueryInstance)queryInstance;
            question.setVariants(instance.getQuery().getAlternatives().stream().map(ImmutableAlternative::getName).collect(Collectors.toList()));
        } else if (queryInstance instanceof DropDownQueryInstance) {
            instance = (DropDownQueryInstance)queryInstance;
            question.setVariants(instance.getQuery().getAlternatives().stream().map(ImmutableAlternative::getName).collect(Collectors.toList()));
        } else {
            question.setVariants(Collections.emptyList());
        }
        questionGroup.addQuestion(question);
    }

    public String getValue(FixedAlternativesQueryInstance queryInstance) {
        Optional optionalValue;
        String value = null;
        List alternatives = queryInstance.getAlternatives();
        if (alternatives != null && (optionalValue = alternatives.stream().findFirst()).isPresent()) {
            value = ((ImmutableAlternative)optionalValue.get()).getName();
        }
        return value;
    }

    private String getXslElementName(ImmutableAlternative alternative) {
        if (alternative instanceof MutableField) {
            return ((MutableField)alternative).getXsdElementName();
        }
        throw new ClassCastException("Cannot cast to IvisExportedMutableField!");
    }

    @Override
    public boolean mach(Class queryClass) {
        return allowedClassList.contains(queryClass);
    }

    private FormField<ImmutableAlternative> createFormField(ImmutableAlternative field) {
        return new BaseFormField<ImmutableAlternative>(field){

            @Override
            public String getValue() {
                return ((ImmutableAlternative)this.field).getName();
            }
        };
    }
}

