/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity;

import com.imcode.entities.ApplicationForm;
import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.oeplatform.flowengine.interfaces.MutableField;
import com.imcode.oeplatform.flowengine.populators.entity.FieldQuestionGroupMapper;
import com.imcode.oeplatform.flowengine.populators.entity.MultipleAlternativeQuestionGroupMapper;
import com.imcode.oeplatform.flowengine.populators.entity.QuestionMapper;
import com.imcode.oeplatform.flowengine.populators.entity.SingleAlternativeQuestionGroupMapper;
import com.imcode.oeplatform.flowengine.populators.entity.StepMapper;
import com.imcode.oeplatform.flowengine.populators.entity.TextAreaQuestionGroupMapper;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQueryInstance;
import com.nordicpeak.flowengine.interfaces.ImmutableFlow;
import com.nordicpeak.flowengine.interfaces.QueryInstance;
import com.nordicpeak.flowengine.managers.FlowInstanceManager;
import com.nordicpeak.flowengine.managers.MutableFlowInstanceManager;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;

public class ApplicationFormFactory {
    public static final Predicate<QueryInstance> DEFAULT_QUERY_CHECKER;
    public static final Predicate<Object> DEFAULT_FIELD_CHECKER;
    private static final QuestionMapper<QueryInstance> DUMMY_MAPPER;
    private Predicate<QueryInstance> queryChecker = DEFAULT_QUERY_CHECKER.and(this::hasMapperFor);
    private Predicate<Object> fieldChecker = DEFAULT_FIELD_CHECKER;
    private Collection<QuestionMapper<? extends QueryInstance>> formQuestionMappers;

    public ApplicationFormFactory() {
        this(DEFAULT_QUERY_CHECKER, DEFAULT_FIELD_CHECKER, new HashSet<QuestionMapper<? extends QueryInstance>>());
    }

    public ApplicationFormFactory(Predicate<QueryInstance> queryChecker, Predicate<Object> fieldChecker, Collection<QuestionMapper<? extends QueryInstance>> formQuestionMappers) {
        Objects.requireNonNull(queryChecker);
        Objects.requireNonNull(fieldChecker);
        Objects.requireNonNull(formQuestionMappers);
        this.queryChecker = queryChecker;
        this.fieldChecker = fieldChecker;
        this.formQuestionMappers = formQuestionMappers;
    }

    public <T extends QueryInstance> void addMapper(QuestionMapper<T> mapper) {
        this.formQuestionMappers.add(mapper);
    }

    public <T extends QueryInstance> QuestionMapper<T> getMapper(Class<T> clazz) {
        return this.getMapper0(clazz);
    }

    public <T extends QueryInstance> QuestionMapper<T> getMapperFor(T instance) {
        Objects.requireNonNull(instance);
        return this.getMapper0(instance.getClass());
    }

    public <T extends QueryInstance> boolean hasMapper(Class<T> clazz) {
        return this.getMapper0(clazz) != null;
    }

    public <T extends QueryInstance> boolean hasMapperFor(T instance) {
        Objects.requireNonNull(instance);
        return this.getMapper0(instance.getClass()) != null;
    }

    private <T extends QueryInstance> QuestionMapper<T> getMapper0(Class<T> clazz) {
        Optional<QuestionMapper> result = this.formQuestionMappers.stream().filter(mapper -> mapper.mach(clazz)).findFirst();
        return result.orElse(DUMMY_MAPPER);
    }

    private Class<?> getRequiredTypeInfo(Object converter, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.forClass(converter.getClass()).as(genericIfc);
        ResolvableType[] generics = resolvableType.getGenerics();
        if (generics.length == 0) {
            return null;
        }
        Class sourceType = generics[0].resolve();
        if (sourceType == null) {
            return null;
        }
        return sourceType;
    }

    public ApplicationForm get(FlowInstanceManager manager) {
        Object questions = null;
        Objects.requireNonNull(manager);
        ImmutableFlow flow = manager.getFlowInstance().getFlow();
        ApplicationForm applicationForm = new ApplicationForm();
        applicationForm.setName(flow.getName());
        applicationForm.setVersion(flow.getVersion());
        List queryList = manager.getQueries(QueryInstance.class);
        StepMapper stepMapper = new StepMapper();
        stepMapper.addMapper(FieldQuestionGroupMapper.forClass(TextFieldQueryInstance.class));
        stepMapper.addMapper(FieldQuestionGroupMapper.forClass(com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextFieldQueryInstance.class));
        stepMapper.addMapper(new SingleAlternativeQuestionGroupMapper());
        stepMapper.addMapper(new MultipleAlternativeQuestionGroupMapper());
        stepMapper.addMapper(new TextAreaQuestionGroupMapper());
        try {
            Field managedStepsField = MutableFlowInstanceManager.class.getDeclaredField("managedSteps");
            managedStepsField.setAccessible(true);
            List managedSteps = (List)managedStepsField.get(manager);
            List steps = managedSteps.stream().map(stepMapper).collect(Collectors.toList());
            applicationForm.setSteps(steps);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return applicationForm;
    }

    public Predicate<QueryInstance> getQueryChecker() {
        return this.queryChecker;
    }

    public void setQueryChecker(Predicate<QueryInstance> queryChecker) {
        this.queryChecker = queryChecker;
    }

    public Predicate<Object> getFieldChecker() {
        return this.fieldChecker;
    }

    public void setFieldChecker(Predicate<Object> fieldChecker) {
        this.fieldChecker = fieldChecker;
    }

    static {
        DUMMY_MAPPER = new QuestionMapper<QueryInstance>(){

            @Override
            public boolean mach(Class queryClass) {
                return false;
            }

            @Override
            public Collection<ApplicationFormQuestion> getQuestions(QueryInstance queryInstance) {
                return Collections.emptyList();
            }
        };
        DEFAULT_QUERY_CHECKER = query -> query.getQueryInstanceDescriptor().getQueryDescriptor().isExported();
        DEFAULT_FIELD_CHECKER = field -> field instanceof MutableField && ((MutableField)field).isExported();
    }
}

