package com.imcode.oeplatform.flowengine.queries.linked.dropdownquery;

import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.oeplatform.flowengine.populators.JsonStringfier;
import com.nordicpeak.flowengine.interfaces.MutableAlternative;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.PositiveStringIntegerPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLValidationUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

//@Table(name = "ivis_drop_down_query_alternatives")
@XMLElement
public class LinkedDropDownAlternative extends GeneratedElementable implements MutableAlternative, Serializable {

//	private Long id;
//
//	private String representation;
//	@DAOManaged(autoGenerated = true)
//	@Key
	@XMLElement
	private Integer alternativeID;
//
//	@DAOManaged
	@WebPopulate(required=true,maxLength=255)
	@XMLElement
	private String name;
//
//	@DAOManaged
//	@OrderBy
	@XMLElement
	private Integer sortIndex;
//
//	@DAOManaged
//	@WebPopulate
//	@XMLElement
//	private boolean exported;
//
//	@DAOManaged
//	@WebPopulate(maxLength = 255, populator=XMLElementNamePopulator.class)
//	@RequiredIfSet(paramName="exported")
//	@XMLElement
//	private String xsdElementName;

	//	@DAOManaged(columnName="queryID")
//	@ManyToOne
	@XMLElement
	private LinkedDropDownQuery query;

	//	@DAOManaged
//	@OneToMany
	@XMLElement
	private List<LinkedDropDownQueryInstance> instances;

	public LinkedDropDownAlternative(){}

	public LinkedDropDownAlternative(Number alternativeID, String name) {
		this.alternativeID = alternativeID.intValue();
		this.name = name;
	}

	//	public LinkedDropDownAlternative(Long id, String representation) {
//		super();
//		this.alternativeID = id;
//		this.representation = representation;
//	}

	@Override
	public Integer getAlternativeID() {

		return alternativeID;
	}

	@Override
	public void setAlternativeID(Integer alternativeID) {

		this.alternativeID = alternativeID;
	}

	public LinkedDropDownQuery getQuery() {

		return query;
	}

	public void setQuery(LinkedDropDownQuery query) {

		this.query = query;
	}

	@Override
	public String getName() {

		return name;
	}

	@Override
	public void setName(String name) {

		this.name = name;
	}

	@Override
	public Integer getSortIndex() {
		return sortIndex;
	}

	@Override
	public void setSortIndex(Integer sortIndex) {
		this.sortIndex = sortIndex;
	}

	public List<LinkedDropDownQueryInstance> getInstances() {

		return instances;
	}


	public void setInstances(List<LinkedDropDownQueryInstance> instances) {

		this.instances = instances;
	}

//	public boolean isExported() {
//		return exported;
//	}
//
//	public void setExported(boolean exported) {
//		this.exported = exported;
//	}
//
//	public String getXsdElementName() {
//		return xsdElementName;
//	}
//
//	public void setXsdElementName(String xsdElementName) {
//		this.xsdElementName = xsdElementName;
//	}

	@Override
	public String toString() {

		return "(" + alternativeID + ")" + name;
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((alternativeID == null) ? 0 : alternativeID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {

		if(this == obj){
			return true;
		}
		if(obj == null){
			return false;
		}
		if(getClass() != obj.getClass()){
			return false;
		}
		LinkedDropDownAlternative other = (LinkedDropDownAlternative)obj;
		if(alternativeID == null){
			if(other.alternativeID != null){
				return false;
			}
		}else if(!alternativeID.equals(other.alternativeID)){
			return false;
		}
		return true;
	}

	@Override
	public void populate(XMLParser xmlParser) throws ValidationException {

		List<ValidationError> errors = new ArrayList<ValidationError>();

		alternativeID = XMLValidationUtils.validateParameter("alternativeID", xmlParser, true, PositiveStringIntegerPopulator.getPopulator(), errors);
		name = XMLValidationUtils.validateParameter("name", xmlParser, true, 1, 255, StringPopulator.getPopulator(), errors);
		sortIndex = XMLValidationUtils.validateParameter("sortIndex", xmlParser, true, 1, 255, IntegerPopulator.getPopulator(), errors);

		if(!errors.isEmpty()){

			throw new ValidationException(errors);
		}
	}

//	@Override
//	public Long getId() {
//		return id;
//	}
//
//	@Override
//	public void setId(Long id) {
//		this.id = id;
//	}
//
//	@Override
//	public String getRepresentation() {
//		return representation;
//	}
//
//	@Override
//	public void setRepresentation(String representation) {
//		this.representation = representation;
//	}
}