package com.imcode.oeplatform.flowengine.queries.dropdownquery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.imcode.oeplatform.flowengine.interfaces.MutableFieldAlternative;
import com.nordicpeak.flowengine.populators.XMLElementNamePopulator;
import se.unlogic.standardutils.annotations.RequiredIfSet;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.PositiveStringIntegerPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLValidationUtils;

@Table(name = "ivis_drop_down_query_alternatives")
@XMLElement
public class DropDownAlternative extends GeneratedElementable implements MutableFieldAlternative, Serializable {

	private static final long serialVersionUID = 5698552791580194144L;

	@DAOManaged(autoGenerated = true)
	@Key
	@XMLElement
	private Integer alternativeID;

	@DAOManaged
	@WebPopulate(required=true,maxLength=255)
	@XMLElement
	private String name;

	@DAOManaged
	@OrderBy
	@XMLElement
	private Integer sortIndex;

	@DAOManaged
	@WebPopulate
	@XMLElement
	private boolean exported;

	@DAOManaged
	@WebPopulate(maxLength = 255, populator=XMLElementNamePopulator.class)
	@RequiredIfSet(paramName="exported")
	@XMLElement
	private String xsdElementName;

	@DAOManaged(columnName="queryID")
	@ManyToOne
	@XMLElement
	private com.imcode.oeplatform.flowengine.queries.dropdownquery.DropDownQuery query;

	@DAOManaged
	@OneToMany
	@XMLElement
	private List<DropDownQueryInstance> instances;

	public DropDownAlternative(){}

	public DropDownAlternative(String name, Integer sortIndex) {

		super();
		this.name = name;
		this.sortIndex = sortIndex;
	}

	@Override
	public Integer getAlternativeID() {

		return alternativeID;
	}

	@Override
	public void setAlternativeID(Integer alternativeID) {

		this.alternativeID = alternativeID;
	}

	public com.imcode.oeplatform.flowengine.queries.dropdownquery.DropDownQuery getQuery() {

		return query;
	}

	public void setQuery(com.imcode.oeplatform.flowengine.queries.dropdownquery.DropDownQuery query) {

		this.query = query;
	}

	@Override
	public String getName() {

		return name;
	}

	@Override
	public void setName(String name) {

		this.name = name;
	}

	@Override
	public Integer getSortIndex() {
		return sortIndex;
	}

	@Override
	public void setSortIndex(Integer sortIndex) {
		this.sortIndex = sortIndex;
	}

	public List<DropDownQueryInstance> getInstances() {

		return instances;
	}


	public void setInstances(List<DropDownQueryInstance> instances) {

		this.instances = instances;
	}

	public boolean isExported() {
		return exported;
	}

	public void setExported(boolean exported) {
		this.exported = exported;
	}

	public String getXsdElementName() {
		return xsdElementName;
	}

	public void setXsdElementName(String xsdElementName) {
		this.xsdElementName = xsdElementName;
	}

	@Override
	public String getLabel() {
		return getName();
	}

	@Override
	public void setLabel(String name) {
		setName(name);
	}

	@Override
	public String toString() {

		return name + " (alternativeID: " + alternativeID + ")";
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((alternativeID == null) ? 0 : alternativeID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {

		if(this == obj){
			return true;
		}
		if(obj == null){
			return false;
		}
		if(getClass() != obj.getClass()){
			return false;
		}
		DropDownAlternative other = (DropDownAlternative)obj;
		if(alternativeID == null){
			if(other.alternativeID != null){
				return false;
			}
		}else if(!alternativeID.equals(other.alternativeID)){
			return false;
		}
		return true;
	}

	@Override
	public void populate(XMLParser xmlParser) throws ValidationException {

		List<ValidationError> errors = new ArrayList<ValidationError>();

		alternativeID = XMLValidationUtils.validateParameter("alternativeID", xmlParser, true, PositiveStringIntegerPopulator.getPopulator(), errors);
		name = XMLValidationUtils.validateParameter("name", xmlParser, true, 1, 255, StringPopulator.getPopulator(), errors);
		sortIndex = XMLValidationUtils.validateParameter("sortIndex", xmlParser, true, 1, 255, IntegerPopulator.getPopulator(), errors);

		if(!errors.isEmpty()){

			throw new ValidationException(errors);
		}

	}

}