/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.ivisclient.controllers.converters;

import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.services.GenericService;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.ServiceInfo;
import java.util.Collections;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;

public class IvisDomainClassConverter<T extends ConversionService & ConverterRegistry>
implements ConditionalGenericConverter,
ApplicationContextAware {
    private final T conversionService;
    private IvisServiceFactory serviceFactory;
    private ToEntityConverter toEntityConverter;
    private ToIdConverter toIdConverter;

    public IvisDomainClassConverter(T conversionService) {
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.serviceFactory.hasServiceFor(targetType.getType()) ? this.toEntityConverter.convert(source, sourceType, targetType) : this.toIdConverter.convert(source, sourceType, targetType);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.toEntityConverter.matches(sourceType, targetType) || this.toIdConverter.matches(sourceType, targetType);
        }
        catch (ConversionMatchAbbreviationException o_O) {
            return false;
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        this.serviceFactory = (IvisServiceFactory)context.getBean(IvisServiceFactory.class);
        this.toEntityConverter = new ToEntityConverter();
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this.toEntityConverter);
    }

    private static final class ConversionMatchAbbreviationException
    extends RuntimeException {
        private ConversionMatchAbbreviationException() {
        }
    }

    private class ToIdConverter
    implements ConditionalGenericConverter {
        private ToIdConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString())) {
                return null;
            }
            if (sourceType.equals((Object)targetType)) {
                return source;
            }
            AbstractIdEntity entity = (AbstractIdEntity)source;
            return IvisDomainClassConverter.this.conversionService.convert((Object)entity.getId(), targetType.getType());
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!IvisDomainClassConverter.this.serviceFactory.hasServiceFor(sourceType.getType())) {
                return false;
            }
            if (sourceType.equals((Object)targetType)) {
                return true;
            }
            if (targetType.hasAnnotation(ModelAttribute.class)) {
                return false;
            }
            Class rawIdType = IvisDomainClassConverter.this.serviceFactory.getServiceInfoFor(sourceType.getType()).getIdClass();
            return targetType.equals((Object)TypeDescriptor.valueOf((Class)rawIdType)) || IvisDomainClassConverter.this.conversionService.canConvert(rawIdType, targetType.getType());
        }
    }

    private class ToEntityConverter
    implements ConditionalGenericConverter {
        private ToEntityConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString())) {
                return null;
            }
            if (sourceType.equals((Object)targetType)) {
                return source;
            }
            Class domainType = targetType.getType();
            ServiceInfo serviceInfo = IvisDomainClassConverter.this.serviceFactory.getServiceInfoFor(domainType);
            GenericService service = serviceInfo.getService();
            return service.find(IvisDomainClassConverter.this.conversionService.convert(source, serviceInfo.getIdClass()));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!IvisDomainClassConverter.this.serviceFactory.hasServiceFor(targetType.getType())) {
                return false;
            }
            if (sourceType.equals((Object)targetType)) {
                return true;
            }
            Class rawIdType = IvisDomainClassConverter.this.serviceFactory.getServiceInfoFor(targetType.getType()).getIdClass();
            return sourceType.equals((Object)TypeDescriptor.valueOf((Class)rawIdType)) || IvisDomainClassConverter.this.conversionService.canConvert(sourceType.getType(), rawIdType);
        }
    }
}

