/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.ivisclient.controllers.converters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Component
public class DateConverter2
implements ConditionalGenericConverter {
    @Value(value="${DatePattern}")
    private String datePattern;

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType() == Date.class && targetType.getType() == String.class) {
            return true;
        }
        return targetType.getType() == Date.class && sourceType.getType() == String.class;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> set = new HashSet<GenericConverter.ConvertiblePair>();
        set.add(new GenericConverter.ConvertiblePair(Date.class, String.class));
        set.add(new GenericConverter.ConvertiblePair(String.class, Date.class));
        return Collections.unmodifiableSet(set);
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType() == Date.class) {
            return this.getAsText((Date)source);
        }
        return this.setAsText((String)source);
    }

    public Date setAsText(String value) {
        if (value == null || StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return new SimpleDateFormat(this.datePattern).parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't convert string \"" + value + "\" to Date.");
        }
    }

    public String getAsText(Date value) {
        if (value == null) {
            return null;
        }
        return new SimpleDateFormat(this.datePattern).format(value);
    }
}

