/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.ivisclient.controllers;

import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.services.GenericService;
import imcode.services.IvisServiceFactory;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.UserApprovalRequiredException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rest"})
public class IvisRestController {
    @Autowired
    public IvisServiceFactory ivisServiceFactory;

    private <T extends AbstractIdEntity> List<T> getListOfEntity(Class<T> entityClass) throws ClassNotFoundException {
        Class<?> serviceClass = Class.forName("com.imcode.services." + entityClass.getSimpleName() + "Service");
        GenericService service = this.ivisServiceFactory.getService(serviceClass);
        List entityList = service.findAll();
        return entityList;
    }

    private <T extends AbstractIdEntity> T getEntity(Class<T> entityClass, Object id) throws ClassNotFoundException {
        Class<?> serviceClass = Class.forName("com.imcode.services." + entityClass.getSimpleName() + "Service");
        GenericService service = this.ivisServiceFactory.getService(serviceClass);
        AbstractIdEntity entity = (AbstractIdEntity)service.find(id);
        return (T)entity;
    }

    @RequestMapping(value={"/{entityClassName}"}, method={RequestMethod.GET})
    public Object getList(@PathVariable(value="entityClassName") String entityClassName) throws ClassNotFoundException {
        Class<?> entityClass = Class.forName("com.imcode.entities." + entityClassName);
        List<?> entityList = this.getListOfEntity(entityClass);
        return entityList;
    }

    @RequestMapping(value={"/{entityClassName}/{id}"}, method={RequestMethod.GET})
    public Object getOne(@PathVariable(value="entityClassName") String entityClassName, @PathVariable(value="id") Long id) throws ClassNotFoundException {
        Class<?> entityClass = Class.forName("com.imcode.entities." + entityClassName);
        Object entity = this.getEntity(entityClass, id);
        return entity;
    }

    @ExceptionHandler(value={UserRedirectRequiredException.class, UserApprovalRequiredException.class, OAuth2AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED, reason="OAuth authorization error")
    public void error() {
    }
}

