/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.ivisclient.controllers;

import com.imcode.entities.Application;
import com.imcode.entities.ApplicationForm;
import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.entities.ApplicationFormQuestionGroup;
import com.imcode.entities.ApplicationFormStep;
import com.imcode.entities.EntityVersion;
import com.imcode.entities.Guardian;
import com.imcode.entities.LogEvent;
import com.imcode.entities.Pupil;
import com.imcode.entities.embed.Decision;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.imcms.addon.ivisclient.controllers.form.ApplicationFormCmd;
import com.imcode.services.ApplicationFormQuestionGroupService;
import com.imcode.services.ApplicationFormQuestionService;
import com.imcode.services.ApplicationFormService;
import com.imcode.services.ApplicationFormStepService;
import com.imcode.services.ApplicationService;
import com.imcode.services.EntityVersionService;
import com.imcode.services.GuardianService;
import com.imcode.services.LogEventService;
import com.imcode.services.PersonService;
import com.imcode.services.PupilService;
import imcode.server.Imcms;
import imcode.services.IvisServiceFactory;
import imcode.services.exceptionhandling.GeneralException;
import imcode.services.utils.IvisOAuth2Utils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/ivis"})
public class IvisController {
    Logger log = Logger.getLogger(IvisController.class.getName());
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private OAuth2ProtectedResourceDetails client;
    public static final String GRANT_TYPE = "authorization_code";
    @Value(value="${AuthorizationCodeHandlerUri}")
    public String tokenHandler;
    @Value(value="${StatementsAddress}")
    private String statementsAddress;
    @Value(value="${ServerAddress}")
    private String serverAddress;
    @Value(value="${ClientAddress}")
    private String clientAddress;

    @RequestMapping(value={"/code"})
    @ResponseBody
    public String getCode(WebRequest webRequest, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="code", required=false) String code, @RequestParam(value="redirect_uri", required=false) String redirectUri, @RequestParam(value="docId", required=false) String docId) throws URISyntaxException, IOException {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)GRANT_TYPE);
        form.add((Object)"code", (Object)code);
        form.add((Object)"redirect_uri", (Object)this.tokenHandler);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", String.format("Basic %s", new String(Base64.encode((byte[])String.format("%s:%s", this.client.getClientId(), this.client.getClientSecret()).getBytes("UTF-8")), "UTF-8")));
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.postForEntity(this.client.getAccessTokenUri(), (Object)httpEntity, OAuth2AccessToken.class, new Object[0]);
        IvisOAuth2Utils.setAccessToken((HttpServletRequest)request, (OAuth2AccessToken)((OAuth2AccessToken)result.getBody()));
        response.sendRedirect(this.clientAddress + "/show.jsp");
        return ((OAuth2AccessToken)result.getBody()).toString();
    }

    @RequestMapping(value={"/token"})
    @ResponseBody
    public String getToken(HttpServletResponse response) throws IOException {
        String s = "sdfas";
        response.sendRedirect(this.clientAddress + "/show.jsp");
        return s;
    }

    @RequestMapping(value={"/{id}"}, params={"status"}, method={RequestMethod.GET})
    public void updateStatus(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") Long applicationId, @RequestParam(value="status") Decision.Status status) throws IOException {
        ApplicationService service = (ApplicationService)this.getIvisServiceFactory(request).getService(ApplicationService.class);
        EntityVersionService entityVersionService = (EntityVersionService)this.getIvisServiceFactory(request).getService(EntityVersionService.class);
        LogEventService logEventService = (LogEventService)this.getIvisServiceFactory(request).getService(LogEventService.class);
        if (IvisOAuth2Utils.getAccessToken((HttpServletRequest)request) != null) {
            try {
                Application application = (Application)service.find((Object)applicationId);
                if (application != null && application.getDecision() != null && !application.getDecision().getStatus().equals((Object)status)) {
                    Date dateNow = new Date();
                    application.getDecision().setStatus(status);
                    application.getDecision().setDate(dateNow);
                    application.setUpdateDate(dateNow);
                    EntityVersion version = new EntityVersion((JpaEntity)application);
                    entityVersionService.save((Object)version);
                    service.save((Object)application);
                }
            }
            catch (UserRedirectRequiredException e) {
                IvisOAuth2Utils.setAccessToken((HttpServletRequest)request, null);
            }
        }
        response.sendRedirect(this.getRequestReferer(request));
    }

    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.POST})
    public void editApplication(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") Long applicationId, @ModelAttribute(value="applicationForm") ApplicationFormCmd applicationFormCmd, BindingResult bindingResult) throws IOException {
        IvisServiceFactory ivisServiceFactory = this.getIvisServiceFactory(request);
        ApplicationService service = (ApplicationService)ivisServiceFactory.getService(ApplicationService.class);
        ApplicationFormQuestionService questionService = (ApplicationFormQuestionService)ivisServiceFactory.getService(ApplicationFormQuestionService.class);
        EntityVersionService versionService = (EntityVersionService)ivisServiceFactory.getService(EntityVersionService.class);
        LogEventService logEventService = (LogEventService)ivisServiceFactory.getService(LogEventService.class);
        Application application = (Application)service.find((Object)applicationId);
        List persistedQuestions = application.getQuestionList();
        Collections.sort(persistedQuestions, JpaEntity.BY_ID_COMPARATOR);
        if (IvisOAuth2Utils.getAccessToken((HttpServletRequest)request) != null) {
            try {
                boolean changed = false;
                ArrayList<ApplicationFormQuestion> questions = new ArrayList<ApplicationFormQuestion>();
                for (ApplicationFormQuestion question : applicationFormCmd.getQuestions()) {
                    int questionIndex = Collections.binarySearch(persistedQuestions, question, JpaEntity.BY_ID_COMPARATOR);
                    if (questionIndex < 0) continue;
                    ApplicationFormQuestion realQuestion = (ApplicationFormQuestion)persistedQuestions.get(questionIndex);
                    if (realQuestion.getMultiValues().booleanValue() && !Objects.equals(realQuestion.getValues(), question.getValues())) {
                        realQuestion.setValues(question.getValues());
                        realQuestion.setValue(question.getValues().stream().collect(Collectors.joining()));
                        questionService.save((Object)realQuestion);
                        changed = true;
                        continue;
                    }
                    if (realQuestion.getMultiValues().booleanValue() || Objects.equals(realQuestion.getValue(), question.getValue())) continue;
                    realQuestion.setValue(question.getValue());
                    realQuestion.setValues(Collections.singletonList(question.getValue()));
                    questions.add(realQuestion);
                    changed = true;
                }
                if (changed) {
                    Date date = new Date();
                    application.setUpdateDate(date);
                    Decision decision = application.getDecision();
                    decision.setDate(date);
                    decision.setStatus(Decision.Status.HANDLED);
                    application.setDecision(decision);
                    EntityVersion version = new EntityVersion((JpaEntity)application);
                    version = (EntityVersion)versionService.save((Object)version);
                    LogEvent log = (LogEvent)logEventService.findByEntity((JpaEntity)application).get(0);
                    log.setTimestamp(version.getTimestamp());
                    log.setAction(LogEvent.Action.MODIFY);
                    log.setId(null);
                    logEventService.save((Object)log);
                    service.save((Object)application);
                    Iterable iterable = questionService.save(questions);
                }
            }
            catch (UserRedirectRequiredException e) {
                IvisOAuth2Utils.setAccessToken((HttpServletRequest)request, null);
            }
        }
        response.sendRedirect(Imcms.getServerProperties().getProperty("ClientAddress") + "/applications/show?id=" + applicationId);
    }

    @RequestMapping(value={"commentDecision/{id}"}, method={RequestMethod.POST})
    public void addDecisionComment(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") Long applicationId) throws IOException {
        String commentTextarea;
        if (IvisOAuth2Utils.getAccessToken((HttpServletRequest)request) != null && !this.isEmptyOrNull(commentTextarea = request.getParameter("commentTextarea"))) {
            Decision decision;
            IvisServiceFactory ivisServiceFactory = this.getIvisServiceFactory(request);
            ApplicationService service = (ApplicationService)ivisServiceFactory.getService(ApplicationService.class);
            Application application = (Application)service.find((Object)applicationId);
            decision.setComment(!(decision = application.getDecision()).getComment().isEmpty() ? decision.getComment() + "<br/>" + commentTextarea : commentTextarea);
            application.setDecision(decision);
            service.save((Object)application);
        }
        response.sendRedirect(Imcms.getServerProperties().getProperty("ClientAddress") + "/applications/show?id=" + applicationId);
    }

    private boolean isEmptyOrNull(String str) {
        return str == null || str.isEmpty();
    }

    @Deprecated
    @RequestMapping(value={"/xml"}, method={RequestMethod.POST})
    public void importApplication(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file", required=false) MultipartFile file, Model model) throws IOException, URISyntaxException {
    }

    @RequestMapping(value={"/xml"}, method={RequestMethod.GET})
    @ResponseBody
    public String showImportApplicationForm() {
        return "xml/show";
    }

    @RequestMapping(value={"/pupils"}, method={RequestMethod.POST})
    public void updatePupil(@ModelAttribute(value="pupil") Pupil pupil, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PupilService pupilService = (PupilService)this.getIvisServiceFactory(request).getService(PupilService.class);
        PersonService personService = (PersonService)this.getIvisServiceFactory(request).getService(PersonService.class);
        GuardianService guardianService = (GuardianService)this.getIvisServiceFactory(request).getService(GuardianService.class);
        if (pupil.getPerson() != null) {
            personService.save((Object)pupil.getPerson());
        }
        if (pupil.getContactPerson() != null) {
            personService.save((Object)pupil.getContactPerson());
        }
        if (pupil.getGuardians() != null) {
            for (Guardian guardian : pupil.getGuardians()) {
                if (guardian == null) continue;
                guardianService.save((Object)guardian);
            }
        }
        pupilService.save((Object)pupil);
        String returnToUri = this.getRequestReferer(request);
        response.sendRedirect(returnToUri);
    }

    @RequestMapping(value={"/applications"}, method={RequestMethod.POST})
    public void updateApplication(@ModelAttribute(value="app") Application application, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ApplicationService applicationService = (ApplicationService)this.getIvisServiceFactory(request).getService(ApplicationService.class);
        applicationService.save((Object)application);
        String returnToUri = this.getRequestReferer(request);
        response.sendRedirect(returnToUri);
    }

    @RequestMapping(value={"/errorhandler"})
    public void handleError(HttpServletRequest request, HttpServletResponse response) {
        Object error = request.getAttribute("javax.servlet.error.exception");
        if (error instanceof GeneralException) {
            try {
                GeneralException generalException = (GeneralException)error;
                URIBuilder uriBuilder = new URIBuilder(this.serverAddress + "/errorhandler");
                uriBuilder.addParameter("body", null);
                uriBuilder.addParameter("error_message", generalException.getErrorMessage());
                uriBuilder.addParameter("error_code", generalException.getErrorCode().toString());
                String collect = generalException.getErrorDescription().stream().collect(Collectors.joining(","));
                uriBuilder.addParameter("error_description", collect);
                response.sendRedirect(uriBuilder.build().toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private String getRequestReferer(HttpServletRequest request) {
        return request.getHeader("referer");
    }

    private void checkServiceFactory(HttpServletRequest request) {
        if (this.getIvisServiceFactory(request) == null) {
            // empty if block
        }
    }

    private IvisServiceFactory getIvisServiceFactory(HttpServletRequest request) {
        return IvisOAuth2Utils.getServiceFactory((HttpServletRequest)request);
    }

    private void saveApplication(Application application, IvisServiceFactory ivisServiceFactory) {
        ApplicationService applicationService = (ApplicationService)ivisServiceFactory.getService(ApplicationService.class);
        ApplicationFormService formService = (ApplicationFormService)ivisServiceFactory.getService(ApplicationFormService.class);
        ApplicationFormStepService stepService = (ApplicationFormStepService)ivisServiceFactory.getService(ApplicationFormStepService.class);
        ApplicationFormQuestionGroupService groupService = (ApplicationFormQuestionGroupService)ivisServiceFactory.getService(ApplicationFormQuestionGroupService.class);
        ApplicationFormQuestionService questionService = (ApplicationFormQuestionService)ivisServiceFactory.getService(ApplicationFormQuestionService.class);
        ApplicationForm form = application.getApplicationForm();
        List steps = form.getSteps();
        for (int s = 0; s < steps.size(); ++s) {
            ApplicationFormStep step = (ApplicationFormStep)steps.get(s);
            List questionGroups = step.getQuestionGroups();
            for (int g = 0; g < questionGroups.size(); ++g) {
                ApplicationFormQuestionGroup questionGroup = (ApplicationFormQuestionGroup)questionGroups.get(g);
                List questions = questionGroup.getQuestions();
                for (int q = 0; q < questions.size(); ++q) {
                    ApplicationFormQuestion question = (ApplicationFormQuestion)questions.get(q);
                    question = (ApplicationFormQuestion)questionService.save((Object)question);
                    questions.set(q, question);
                }
                questionGroup = (ApplicationFormQuestionGroup)groupService.save((Object)questionGroup);
                questionGroups.set(g, questionGroup);
            }
            step = (ApplicationFormStep)stepService.save((Object)step);
            steps.set(s, step);
        }
        form = (ApplicationForm)formService.save((Object)form);
        application.setApplicationForm(form);
        application = (Application)applicationService.save((Object)application);
        this.log.info("Application id = " + application.getId() + " created.");
    }
}

