/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.imcode.entities.Category;
import com.imcode.entities.Issue;
import com.imcode.entities.Person;
import com.imcode.entities.Priority;
import com.imcode.entities.Pupil;
import com.imcode.entities.Status;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="dbo_incident")
public class Incident
extends AbstractIdEntity<Long>
implements Serializable {
    @Column(nullable=false)
    @NotNull(message="title can not be null")
    private String title;
    @Column(columnDefinition="text")
    @NotNull(message="description can not be null")
    private String description;
    @Column(name="report_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="reported_date")
    private Date reportDay;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_incident_category_cross", joinColumns={@JoinColumn(name="incident_id")}, inverseJoinColumns={@JoinColumn(name="category_id")})
    @Size(min=1, message="categories can not be null")
    private Set<Category> categories = new HashSet<Category>();
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_incident_pupil_cross", joinColumns={@JoinColumn(name="incident_id")}, inverseJoinColumns={@JoinColumn(name="pupil_id")})
    @Size(min=1, message="pupils can not be null")
    private Set<Pupil> pupils = new HashSet<Pupil>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="status_id")
    private Status status;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="priority_id")
    @NotNull(message="priority can not be null")
    private Priority priority;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="issue_id")
    private Issue issue;
    @Column(name="assigned_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="assigned_date")
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date assignedDay;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="assigned_person_id")
    @JsonProperty(value="assigned_by")
    private Person assignedBy;
    @Column(name="archived_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="archived_date")
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date archivedDay;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="archived_person_id")
    @JsonProperty(value="archived_by")
    private Person archivedBy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="reported_person_id")
    @JsonProperty(value="reported_by")
    private Person reportedBy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="modified_person_id")
    @JsonProperty(value="modified_by")
    private Person modifiedBy;
    @Column(name="modified_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="modified_date")
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date modifiedDay;

    public Incident() {
    }

    public Incident(Long aLong) {
        super(aLong);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getReportDay() {
        return this.reportDay;
    }

    public void setReportDay(Date reportDay) {
        this.reportDay = reportDay;
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }

    public Set<Pupil> getPupils() {
        return this.pupils;
    }

    public void setPupils(Set<Pupil> pupils) {
        this.pupils = pupils;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @JsonIgnoreProperties(value={"incidents", "activities"})
    public Issue getIssue() {
        return this.issue;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public Date getAssignedDay() {
        return this.assignedDay;
    }

    public void setAssignedDay(Date assignedDay) {
        this.assignedDay = assignedDay;
    }

    public Person getAssignedBy() {
        return this.assignedBy;
    }

    public void setAssignedBy(Person assignedBy) {
        this.assignedBy = assignedBy;
    }

    public Date getArchivedDay() {
        return this.archivedDay;
    }

    public void setArchivedDay(Date archivedDay) {
        this.archivedDay = archivedDay;
    }

    public Person getArchivedBy() {
        return this.archivedBy;
    }

    public void setArchivedBy(Person archivedBy) {
        this.archivedBy = archivedBy;
    }

    public Person getReportedBy() {
        return this.reportedBy;
    }

    public void setReportedBy(Person reportedBy) {
        this.reportedBy = reportedBy;
    }

    public Person getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Person modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedDay() {
        return this.modifiedDay;
    }

    public void setModifiedDay(Date modifiedDay) {
        this.modifiedDay = modifiedDay;
    }
}

