/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.json.EntityVersionDeserializer;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@JsonDeserialize(using=EntityVersionDeserializer.class)
@Entity
@Table(name="dbo_entity_version")
public class EntityVersion
extends AbstractIdEntity<Long> {
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;
    @Column(name="entity_class", nullable=false)
    @JsonProperty(value="entity_class")
    private Class<?> entityClass;
    @Column(name="entity_id", nullable=false)
    @JsonProperty(value="entity_id")
    private Long entityId;
    @Column
    @Lob
    private Serializable entity;

    public EntityVersion() {
    }

    public EntityVersion(Long aLong) {
        super(aLong);
    }

    public EntityVersion(JpaEntity<Long> entity) {
        this.entityClass = entity.getClass();
        this.timestamp = new Date();
        this.entityId = entity.getId();
        this.entity = entity;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Serializable getEntity() {
        return this.entity;
    }

    public void setEntity(JpaEntity<?> entity) {
        this.entity = entity;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }
}

