/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.imcode.entities.AfterSchoolCenterSection;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.enums.ServiceTypeEnum;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="dbo_school")
public class School
extends AbstractNamedEntity<Long>
implements Serializable {
    @Column
    @JsonProperty(value="school_id")
    private String schoolId;
    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    @JoinTable(name="dbo_school_service_cross")
    private Set<ServiceTypeEnum> services;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="school", cascade={CascadeType.REFRESH})
    @JsonProperty(value="school_classes")
    private Set<SchoolClass> schoolClasses;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="school")
    @JsonProperty(value="after_school_center_sections")
    private Set<AfterSchoolCenterSection> afterSchoolCenterSections;

    public Set<ServiceTypeEnum> getServices() {
        return this.services;
    }

    public void setServices(Set<ServiceTypeEnum> services) {
        this.services = services;
    }

    @JsonIgnore
    public void setServices(ServiceTypeEnum ... services) {
        this.services = new HashSet<ServiceTypeEnum>(Arrays.asList(services));
    }

    public String getSchoolId() {
        return this.schoolId;
    }

    public void setSchoolId(String schoolId) {
        this.schoolId = schoolId;
    }

    public Set<SchoolClass> getSchoolClasses() {
        return this.schoolClasses;
    }

    public void setSchoolClasses(Set<SchoolClass> schoolClasses) {
        this.schoolClasses = schoolClasses;
    }

    public Set<AfterSchoolCenterSection> getAfterSchoolCenterSections() {
        return this.afterSchoolCenterSections;
    }

    public void setAfterSchoolCenterSections(Set<AfterSchoolCenterSection> afterSchoolCenterSections) {
        this.afterSchoolCenterSections = afterSchoolCenterSections;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

