/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.imcode.entities.User;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="dbo_log_event")
public class LogEvent
extends AbstractIdEntity<Long> {
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;
    @Column(nullable=false)
    @JsonProperty(value="entity_class_name")
    private String entityClassName;
    @Column(nullable=false)
    @JsonProperty(value="entity_id")
    private Long entityId;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Action action;
    @Column
    @JsonProperty(value="field_name")
    private String fieldName;
    @Column
    @JsonProperty(value="previous_value")
    private String previousValue;
    @Column
    @JsonProperty(value="new_value")
    private String newValue;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="userId")
    private User user;

    public LogEvent() {
    }

    public LogEvent(Long aLong) {
        super(aLong);
    }

    public LogEvent(JpaEntity<Long> entity, Action action, String fieldName, String previousValue, String newValue, User user) {
        this.entityClassName = entity.getClass().getName();
        this.timestamp = new Date();
        this.action = action;
        this.entityId = entity.getId();
        this.fieldName = fieldName;
        this.previousValue = previousValue;
        this.newValue = newValue;
        this.user = user;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getPreviousValue() {
        return this.previousValue;
    }

    public void setPreviousValue(String previousValue) {
        this.previousValue = previousValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum Action {
        CREATE,
        MODIFY,
        DELETE;

    }
}

