/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.imcode.entities.ApplicationForm;
import com.imcode.entities.ApplicationFormQuestionGroup;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.superclasses.AbstractSortableNamedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="dbo_application_form_step")
public class ApplicationFormStep
extends AbstractSortableNamedEntity<Long> {
    @Column
    private String text;
    @OrderBy(value="sortOrder ASC, text ASC")
    @OneToMany(fetch=FetchType.EAGER, mappedBy="step")
    @JsonProperty(value="question_groups")
    private List<ApplicationFormQuestionGroup> questionGroups = new ArrayList<ApplicationFormQuestionGroup>();
    @ManyToOne
    @JsonProperty(value="application_form")
    private ApplicationForm applicationForm;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<ApplicationFormQuestionGroup> getQuestionGroups() {
        return this.questionGroups;
    }

    public void setQuestionGroups(List<ApplicationFormQuestionGroup> questionGroups) {
        this.questionGroups = questionGroups;
    }

    @JsonIgnoreProperties(value={"steps", "applications"})
    public ApplicationForm getApplicationForm() {
        return this.applicationForm;
    }

    public void setApplicationForm(ApplicationForm applicationForm) {
        this.applicationForm = applicationForm;
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (!super.deepEquals(entity)) {
            return false;
        }
        ApplicationFormStep that = (ApplicationFormStep)entity;
        return Objects.equals(this.text, that.text) && JpaEntity.deepEquals(this.questionGroups, that.questionGroups);
    }

    public void addQuestionGroup(ApplicationFormQuestionGroup questionGroup) {
        this.questionGroups.add(questionGroup);
    }
}

