/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.imcode.entities.embed.Address;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.AddressTypeEnum;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.entities.superclasses.AbstractPerson;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="dbo_person")
@JsonIgnoreProperties(value={"person"})
public class Person
extends AbstractPerson
implements Serializable {
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_address", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="typeKey", length=50)
    private Map<AddressTypeEnum, Address> addresses = new EnumMap<AddressTypeEnum, Address>(AddressTypeEnum.class);
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_email", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="typeKey", length=50)
    private Map<CommunicationTypeEnum, Email> emails = new EnumMap<CommunicationTypeEnum, Email>(CommunicationTypeEnum.class);
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_phone", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="typeKey", length=50)
    private Map<CommunicationTypeEnum, Phone> phones = new EnumMap<CommunicationTypeEnum, Phone>(CommunicationTypeEnum.class);

    public Person() {
    }

    public Person(String pid, String firstName, String lastName) {
        super(pid, firstName, lastName);
    }

    @Override
    public Person getPerson() {
        return this;
    }

    @Override
    public void setPerson(Person person) {
    }

    @Override
    public Map<AddressTypeEnum, Address> getAddresses() {
        return this.addresses;
    }

    @Override
    public void setAddresses(Map<AddressTypeEnum, Address> addresses) {
        this.addresses = this.convertToEnumMap(addresses, AddressTypeEnum.class);
    }

    @Override
    @JsonIgnore
    public void setAddress(Address address) {
        EnumMap map = (EnumMap)this.addresses;
        Person.putAddressValueIntoMap(AddressTypeEnum.class, address, map);
    }

    @Override
    @JsonIgnore
    public Address getAddress(AddressTypeEnum addressType) {
        Objects.requireNonNull(addressType);
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.get((Object)addressType);
    }

    @Override
    public Map<CommunicationTypeEnum, Email> getEmails() {
        return this.emails;
    }

    @Override
    public void setEmails(Map<CommunicationTypeEnum, Email> emails) {
        this.emails = this.convertToEnumMap(emails, CommunicationTypeEnum.class);
    }

    @Override
    @JsonIgnore
    public void setEmail(Email email) {
        EnumMap map = (EnumMap)this.emails;
        Person.putAddressValueIntoMap(CommunicationTypeEnum.class, email, map);
    }

    @Override
    @JsonIgnore
    public Email getEmail(CommunicationTypeEnum type) {
        Objects.requireNonNull(type);
        if (this.emails == null) {
            return null;
        }
        return this.emails.get((Object)type);
    }

    @Override
    public Map<CommunicationTypeEnum, Phone> getPhones() {
        return this.phones;
    }

    @Override
    public void setPhones(Map<CommunicationTypeEnum, Phone> phones) {
        this.phones = this.convertToEnumMap(phones, CommunicationTypeEnum.class);
    }

    @Override
    @JsonIgnore
    public void setPhone(Phone phone) {
        EnumMap map = (EnumMap)this.phones;
        Person.putAddressValueIntoMap(CommunicationTypeEnum.class, phone, map);
    }

    @Override
    @JsonIgnore
    public Phone getPhone(CommunicationTypeEnum type) {
        Objects.requireNonNull(type);
        if (this.emails == null) {
            return null;
        }
        return this.phones.get((Object)type);
    }

    public static Person fromString(String firstNameLastName) {
        if (firstNameLastName == null || firstNameLastName.isEmpty()) {
            throw new IllegalArgumentException("The \"firstNameLastName\" should be not epmty!");
        }
        Person person = new Person();
        String[] parts = firstNameLastName.split(" ");
        person.setFirstName(parts[0]);
        try {
            person.setLastName(parts[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return person;
    }

    private void addWord(StringBuilder sb, String word) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(' ');
        }
        sb.append(word);
    }

    private <K extends Enum<K>, V> EnumMap<K, V> convertToEnumMap(Map<K, V> newValue, Class<K> type) {
        if (!(newValue instanceof EnumMap)) {
            if (newValue == null || newValue.isEmpty()) {
                return new EnumMap(type);
            }
            return new EnumMap<K, V>(newValue);
        }
        return (EnumMap)newValue;
    }
}

