/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.imcode.entities.Activity;
import com.imcode.entities.Category;
import com.imcode.entities.Incident;
import com.imcode.entities.Person;
import com.imcode.entities.Priority;
import com.imcode.entities.Pupil;
import com.imcode.entities.Status;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="dbo_issue")
public class Issue
extends AbstractIdEntity<Long>
implements Serializable {
    @Column(nullable=false)
    @NotNull(message="title can not be null")
    private String title;
    @Column(columnDefinition="text")
    @NotNull(message="description can not be null")
    private String description;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="statusId")
    @NotNull(message="status can not be null")
    private Status status;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="personId")
    @JsonProperty(value="responsible_person")
    @NotNull(message="responsible person can not be null")
    private Person responsiblePerson;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_issues_authorized_persons_cross", joinColumns={@JoinColumn(name="issueId")}, inverseJoinColumns={@JoinColumn(name="personId")})
    @JsonProperty(value="authorized_persons")
    @Size(min=1, message="authorized persons can not be null")
    private Set<Person> authorizedPersons = new HashSet<Person>();
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="issue")
    @Size(min=1, message="incidents can not be null")
    private Set<Incident> incidents = new HashSet<Incident>();
    @Column(name="report_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="reported_date")
    private Date reportDay;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="reported_person_id")
    @JsonProperty(value="reported_by")
    private Person reportedBy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="modified_person_id")
    @JsonProperty(value="modified_by")
    private Person modifiedBy;
    @Column(name="modified_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="modified_date")
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date modifiedDay;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="issue")
    private Set<Activity> activities = new HashSet<Activity>();
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_issue_category_cross", joinColumns={@JoinColumn(name="issueId")}, inverseJoinColumns={@JoinColumn(name="categoryId")})
    private Set<Category> categories = new HashSet<Category>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="priorityId")
    private Priority priority;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_issue_pupil_cross", joinColumns={@JoinColumn(name="issueId")}, inverseJoinColumns={@JoinColumn(name="pupilId")})
    private Set<Pupil> pupils = new HashSet<Pupil>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="assigned_person_id")
    @JsonProperty(value="assigned_by")
    private Person assigneddBy;
    @Column(name="assigned_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="assigned_date")
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date assignedDay;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="archived_person_id")
    @JsonProperty(value="archived_by")
    private Person archiveddBy;
    @Column(name="archived_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="archived_date")
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date archivedDay;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Person getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public void setResponsiblePerson(Person responsiblePerson) {
        this.responsiblePerson = responsiblePerson;
    }

    public Set<Person> getAuthorizedPersons() {
        return this.authorizedPersons;
    }

    public void setAuthorizedPersons(Set<Person> authorizedPersons) {
        this.authorizedPersons = authorizedPersons;
    }

    public Set<Incident> getIncidents() {
        return this.incidents;
    }

    public void setIncidents(Set<Incident> incidents) {
        this.incidents = incidents;
    }

    public Date getReportDay() {
        return this.reportDay;
    }

    public void setReportDay(Date reportDay) {
        this.reportDay = reportDay;
    }

    public Person getReportedBy() {
        return this.reportedBy;
    }

    public void setReportedBy(Person reportedBy) {
        this.reportedBy = reportedBy;
    }

    public Person getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Person modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedDay() {
        return this.modifiedDay;
    }

    public void setModifiedDay(Date modifiedDay) {
        this.modifiedDay = modifiedDay;
    }

    public Set<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<Activity> activities) {
        this.activities = activities;
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Set<Pupil> getPupils() {
        return this.pupils;
    }

    public void setPupils(Set<Pupil> pupils) {
        this.pupils = pupils;
    }

    public Person getAssigneddBy() {
        return this.assigneddBy;
    }

    public void setAssigneddBy(Person assigneddBy) {
        this.assigneddBy = assigneddBy;
    }

    public Date getAssignedDay() {
        return this.assignedDay;
    }

    public void setAssignedDay(Date assignedDay) {
        this.assignedDay = assignedDay;
    }

    public Person getArchiveddBy() {
        return this.archiveddBy;
    }

    public void setArchiveddBy(Person archiveddBy) {
        this.archiveddBy = archiveddBy;
    }

    public Date getArchivedDay() {
        return this.archivedDay;
    }

    public void setArchivedDay(Date archivedDay) {
        this.archivedDay = archivedDay;
    }
}

