/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.listners;

import com.imcode.entities.LogEvent;
import com.imcode.entities.interfaces.JpaAuditableEntity;
import com.imcode.entities.observer.LogUtils;
import com.imcode.entities.observer.ObserverRegistry;
import java.util.Map;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PreUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditableModelListener {
    private static Logger logger = LoggerFactory.getLogger(AuditableModelListener.class);

    @PostLoad
    public void postLoad(JpaAuditableEntity model) {
        model.setLoadedValues(LogUtils.getValues(model));
    }

    @PostRemove
    public void preRemove(JpaAuditableEntity model) {
        logger.debug("PreRemove %s", (Object)model.getClass().getSimpleName());
        ObserverRegistry.notifyChange(model, LogEvent.Action.DELETE, null, model, null);
    }

    @PostPersist
    public void prePersist(JpaAuditableEntity model) {
        logger.debug("PrePersist %s", (Object)model.getClass().getSimpleName());
        ObserverRegistry.notifyChange(model, LogEvent.Action.CREATE, null, null, null);
    }

    @PreUpdate
    public void preUpdate(JpaAuditableEntity model) {
        logger.debug("PreUpdate %s", (Object)model.getClass().getSimpleName());
        Map<String, Object> newValues = LogUtils.getValues(model);
        Map<String, Object> oldValues = model.getLoadedValues();
        if (oldValues == null) {
            logger.warn("The old values for model %s are null", (Object)model.toString());
            return;
        }
        for (LogUtils.Difference difference : LogUtils.getDifferences(oldValues, newValues)) {
            ObserverRegistry.notifyChange(model, LogEvent.Action.MODIFY, difference.field, difference.oldValue, difference.newValue);
        }
    }
}

