/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.imcode.entities.EntityVersion;
import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.interfaces.JpaEntity;
import java.io.IOException;
import java.util.Date;

public class EntityVersionDeserializer
extends JsonDeserializer<EntityVersion> {
    public EntityVersion deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EntityVersion result = new EntityVersion();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        long entityVersionId = node.get("id").longValue();
        Long id = entityVersionId == 0L ? null : Long.valueOf(entityVersionId);
        Long entityId = node.get("entity_id").longValue();
        String entityClassName = node.get("entity_class").asText();
        Date timestamp = new Date(node.get("timestamp").asLong());
        Class<?> entityClass = null;
        JpaEntity entity = null;
        try {
            entityClass = Class.forName(entityClassName);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
            entity = (JpaEntity)mapper.readValue(node.get("entity").traverse(), entityClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.setId(id);
        result.setEntityClass(entityClass);
        result.setEntityId(entityId);
        result.setTimestamp(timestamp);
        result.setEntity(entity);
        return result;
    }

    public static void main(String[] args) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        User user = new User("admin", "pass", new Role("ROLE_ADMIN"));
        EntityVersion result = new EntityVersion(user);
        String versionString = mapper.writeValueAsString((Object)result);
        System.out.println(versionString);
        EntityVersion entityVersion = (EntityVersion)mapper.readValue(versionString, EntityVersion.class);
        System.out.println(entityVersion);
    }
}

