/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.imcode.entities.Activity;
import com.imcode.entities.Category;
import com.imcode.entities.Incident;
import com.imcode.entities.Person;
import com.imcode.entities.Priority;
import com.imcode.entities.Pupil;
import com.imcode.entities.Status;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="dbo_issue")
public class Issue
extends AbstractIdEntity<Long>
implements Serializable {
    @Column(nullable=false)
    private String title;
    @Column(columnDefinition="text")
    private String description;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="status_id")
    private Status status;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="person_id")
    private Person responsiblePerson;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_issues_authorized_persons_cross", joinColumns={@JoinColumn(name="issue_id")}, inverseJoinColumns={@JoinColumn(name="person_id")})
    private Set<Person> authorizedPersons = new HashSet<Person>();
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="issue")
    private Set<Incident> incidents = new HashSet<Incident>();
    @Column(name="report_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date reportedDate;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="reported_person_id")
    private Person reportedBy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="modified_person_id")
    private Person modifiedBy;
    @Column(name="modified_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonSerialize(using=DateSerializer.class)
    @JsonDeserialize(using=DateDeserializers.DateDeserializer.class)
    private Date modifiedDate;
    @OneToMany(mappedBy="issue")
    private Set<Activity> activities = new HashSet<Activity>();
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_issue_category_cross", joinColumns={@JoinColumn(name="issue_id")}, inverseJoinColumns={@JoinColumn(name="category_id")})
    private Set<Category> categories = new HashSet<Category>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="priority_id")
    private Priority priority;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_issue_pupil_cross", joinColumns={@JoinColumn(name="issue_id")}, inverseJoinColumns={@JoinColumn(name="pupil_id")})
    private Set<Pupil> pupils = new HashSet<Pupil>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Person getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public void setResponsiblePerson(Person responsiblePerson) {
        this.responsiblePerson = responsiblePerson;
    }

    public Set<Person> getAuthorizedPersons() {
        return this.authorizedPersons;
    }

    public void setAuthorizedPersons(Set<Person> authorizedPersons) {
        this.authorizedPersons = authorizedPersons;
    }

    public Set<Incident> getIncidents() {
        return this.incidents;
    }

    public void setIncidents(Set<Incident> incidents) {
        this.incidents = incidents;
    }

    public Date getReportedDate() {
        return this.reportedDate;
    }

    public void setReportedDate(Date reportedDate) {
        this.reportedDate = reportedDate;
    }

    public Person getReportedBy() {
        return this.reportedBy;
    }

    public void setReportedBy(Person reportedBy) {
        this.reportedBy = reportedBy;
    }

    public Person getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Person modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Set<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<Activity> activities) {
        this.activities = activities;
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Set<Pupil> getPupils() {
        return this.pupils;
    }

    public void setPupils(Set<Pupil> pupils) {
        this.pupils = pupils;
    }
}

