/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.superclasses;

import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.interfaces.JpaSortableEntity;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.ObjectUtils;

@MappedSuperclass
public abstract class AbstractSortableNamedEntity<ID extends Serializable>
extends AbstractNamedEntity<ID>
implements JpaSortableEntity<AbstractSortableNamedEntity> {
    @Column(name="sort_order")
    protected Integer sortOrder;

    public AbstractSortableNamedEntity() {
    }

    public AbstractSortableNamedEntity(ID id, String name, Integer sortOrder) {
        super(id, name);
        this.sortOrder = sortOrder;
    }

    @Override
    public Integer getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compareTo(AbstractSortableNamedEntity o) {
        int result = JpaSortableEntity.DEFAULT_COMPARATOR.compare(this, o);
        return result == 0 ? ObjectUtils.compare((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()), (boolean)true) : result;
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (!super.deepEquals(entity)) {
            return false;
        }
        AbstractSortableNamedEntity that = (AbstractSortableNamedEntity)entity;
        return Objects.equals(this.sortOrder, that.sortOrder);
    }
}

