/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.embed.Address;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.AddressTypeEnum;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.entities.superclasses.ContactInformation;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.springframework.util.StringUtils;

@Entity
@Table(name="dbo_person")
public class Person
extends AbstractIdEntity<Long>
implements Serializable,
JpaPersonalizedEntity {
    @Column(name="personal_id")
    private String personalId;
    @NotNull(message="firstName is required")
    @Size(min=4, message="at least firstName must have 4 characters")
    @Column(name="first_name")
    private String firstName;
    @NotNull(message="lastName is required")
    @Size(min=4, message="at least lastName must have 4 characters")
    @Column(name="last_name")
    private String lastName;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_address", joinColumns={@JoinColumn(name="owner_id")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="type_key", length=50)
    private Map<AddressTypeEnum, Address> addresses = new EnumMap<AddressTypeEnum, Address>(AddressTypeEnum.class);
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_email", joinColumns={@JoinColumn(name="owner_id")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="type_key", length=50)
    private Map<CommunicationTypeEnum, Email> emails = new EnumMap<CommunicationTypeEnum, Email>(CommunicationTypeEnum.class);
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_phone", joinColumns={@JoinColumn(name="owner_id")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="type_key", length=50)
    private Map<CommunicationTypeEnum, Phone> phones = new EnumMap<CommunicationTypeEnum, Phone>(CommunicationTypeEnum.class);

    public Person() {
    }

    public Person(String pid, String firstName, String lastName) {
        this.personalId = pid;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Map<AddressTypeEnum, Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Map<AddressTypeEnum, Address> addresses) {
        this.addresses = this.convertToEnumMap(addresses, AddressTypeEnum.class);
    }

    @JsonIgnore
    public void setAddress(Address address) {
        EnumMap map = (EnumMap)this.addresses;
        Person.putAddressValueIntoMap(AddressTypeEnum.class, address, map);
    }

    @JsonIgnore
    public Address getAddress(AddressTypeEnum addressType) {
        Objects.requireNonNull(addressType);
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.get((Object)addressType);
    }

    public Map<CommunicationTypeEnum, Email> getEmails() {
        return this.emails;
    }

    public void setEmails(Map<CommunicationTypeEnum, Email> emails) {
        this.emails = this.convertToEnumMap(emails, CommunicationTypeEnum.class);
    }

    @JsonIgnore
    public void setEmail(Email email) {
        EnumMap map = (EnumMap)this.emails;
        Person.putAddressValueIntoMap(CommunicationTypeEnum.class, email, map);
    }

    @JsonIgnore
    public Email getEmail(CommunicationTypeEnum type) {
        Objects.requireNonNull(type);
        if (this.emails == null) {
            return null;
        }
        return this.emails.get((Object)type);
    }

    public Map<CommunicationTypeEnum, Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(Map<CommunicationTypeEnum, Phone> phones) {
        this.phones = this.convertToEnumMap(phones, CommunicationTypeEnum.class);
    }

    @JsonIgnore
    public void setPhone(Phone phone) {
        EnumMap map = (EnumMap)this.phones;
        Person.putAddressValueIntoMap(CommunicationTypeEnum.class, phone, map);
    }

    @JsonIgnore
    public Phone getPhone(CommunicationTypeEnum type) {
        Objects.requireNonNull(type);
        if (this.emails == null) {
            return null;
        }
        return this.phones.get((Object)type);
    }

    @Override
    @JsonIgnore
    public Person getPerson() {
        return this;
    }

    @Override
    @JsonIgnore
    public void setPerson(Person person) {
        throw new UnsupportedOperationException();
    }

    public static Person fromString(String firstNameLastName) {
        if (firstNameLastName == null || firstNameLastName.isEmpty()) {
            throw new IllegalArgumentException("The \"firstNameLastName\" should be not epmty!");
        }
        Person person = new Person();
        String[] parts = firstNameLastName.split(" ");
        person.setFirstName(parts[0]);
        try {
            person.setLastName(parts[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return person;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)this.firstName)) {
            this.addWord(sb, this.firstName);
        }
        if (StringUtils.hasText((String)this.lastName)) {
            this.addWord(sb, this.lastName);
        }
        if (sb.length() == 0) {
            this.addWord(sb, this.personalId);
        }
        return sb.toString();
    }

    private void addWord(StringBuilder sb, String word) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(' ');
        }
        sb.append(word);
    }

    private <K extends Enum<K>, V> EnumMap<K, V> convertToEnumMap(Map<K, V> newValue, Class<K> type) {
        if (!(newValue instanceof EnumMap)) {
            if (newValue == null || newValue.isEmpty()) {
                return new EnumMap(type);
            }
            return new EnumMap<K, V>(newValue);
        }
        return (EnumMap)newValue;
    }

    protected static <K extends Enum<K>, V extends ContactInformation<K>> void putAddressValueIntoMap(Class<K> enumClass, V addressValue, Map<K, V> map) {
        Objects.requireNonNull(addressValue);
        K addressValueType = addressValue.getType();
        Objects.requireNonNull(addressValueType);
        if (map == null) {
            map = new EnumMap(enumClass);
        }
        map.put(addressValueType, addressValue);
    }
}

