/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.entities.ApplicationFormStep;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.superclasses.AbstractSortableNamedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="dbo_application_form_question_group")
public class ApplicationFormQuestionGroup
extends AbstractSortableNamedEntity<Long> {
    @Column
    private String text;
    @OrderBy(value="sortOrder ASC, text ASC")
    @OneToMany(fetch=FetchType.EAGER, mappedBy="questionGroup")
    private List<ApplicationFormQuestion> questions = new ArrayList<ApplicationFormQuestion>();
    @Column(name="question_type")
    private String questionType;
    @ManyToOne
    private ApplicationFormStep step;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<ApplicationFormQuestion> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<ApplicationFormQuestion> questions) {
        this.questions = questions;
    }

    @JsonIgnoreProperties(value={"question_groups"})
    public ApplicationFormStep getStep() {
        return this.step;
    }

    public void setStep(ApplicationFormStep step) {
        this.step = step;
    }

    public String getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (!super.deepEquals(entity)) {
            return false;
        }
        ApplicationFormQuestionGroup that = (ApplicationFormQuestionGroup)entity;
        return Objects.equals(this.text, that.text) && Objects.equals(this.questionType, that.questionType) && JpaEntity.deepEquals(this.questions, that.questions);
    }

    public void addQuestion(ApplicationFormQuestion question) {
        this.questions.add(question);
    }
}

