/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.Permission;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.GrantedAuthority;

@Entity
@Table(name="dbo_role")
@AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="authority", nullable=false, length=100, unique=true))})
public class Role
extends AbstractNamedEntity<Long>
implements GrantedAuthority,
Serializable {
    @NotNull
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="dbo_role_permission_cross", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")})
    private Set<Permission> permissions = new HashSet<Permission>();
    @Column
    private Boolean internal;
    @NotNull
    @Column(name="user_role")
    private Boolean userRole;

    public Role() {
    }

    public Role(String name) {
        this.name = name;
    }

    public Role(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    @JsonIgnore
    public String getAuthority() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Role{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @JsonIgnore
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    @JsonIgnore
    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public Boolean getUserRole() {
        return this.userRole;
    }

    public void setUserRole(Boolean userRole) {
        this.userRole = userRole;
    }
}

