/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.imcode.entities.ApplicationForm;
import com.imcode.entities.ApplicationFormQuestion;
import com.imcode.entities.Person;
import com.imcode.entities.User;
import com.imcode.entities.embed.Decision;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.listners.AuditableModelListener;
import com.imcode.entities.listners.DatedEntityListner;
import com.imcode.entities.superclasses.AbstractJpaDatedEntity;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="dbo_application")
@EntityListeners(value={AuditableModelListener.class, DatedEntityListner.class})
public class Application
extends AbstractJpaDatedEntity<Long>
implements Serializable {
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="application_form_id")
    @JsonIgnoreProperties(value={"applications"})
    private ApplicationForm applicationForm;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="submitted_user_id")
    private User submittedUser;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="regarding_user_id")
    private User regardingUser;
    @Column(name="registration_number")
    private Long registrationNumber;
    @Embedded
    private Decision decision;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="handled_user_id")
    private Person handledUser;

    public ApplicationForm getApplicationForm() {
        return this.applicationForm;
    }

    public void setApplicationForm(ApplicationForm applicationForm) {
        this.applicationForm = applicationForm;
    }

    public User getSubmittedUser() {
        return this.submittedUser;
    }

    public void setSubmittedUser(User submittedUser) {
        this.submittedUser = submittedUser;
    }

    public User getRegardingUser() {
        return this.regardingUser;
    }

    public void setRegardingUser(User regardingUser) {
        this.regardingUser = regardingUser;
    }

    public Long getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(Long registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public void setDecision(Decision decision) {
        this.decision = decision;
    }

    public Person getHandledUser() {
        return this.handledUser;
    }

    public void setHandledUser(Person handledUser) {
        this.handledUser = handledUser;
    }

    @JsonIgnore
    @Transient
    public Decision.Status getStatus() {
        if (this.decision != null) {
            return this.decision.getStatus();
        }
        return null;
    }

    @JsonIgnore
    @Transient
    public void setStatus(Decision.Status status) {
        if (this.decision == null) {
            this.decision = new Decision();
        }
        this.decision.setStatus(status);
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (!super.deepEquals(entity)) {
            return false;
        }
        Application that = (Application)entity;
        return Objects.equals(this.id, that.id) && Objects.equals(this.decision, that.decision) && Objects.equals(this.regardingUser, that.regardingUser) && Objects.equals(this.registrationNumber, that.registrationNumber) && Objects.equals(this.handledUser, that.handledUser) && Objects.equals(this.submittedUser, that.submittedUser) && JpaEntity.deepEquals(this.applicationForm, that.applicationForm);
    }

    @JsonIgnore
    public Optional<ApplicationFormQuestion> findQuestion(String name, boolean ignoreCase) {
        Predicate<ApplicationFormQuestion> filter = ignoreCase ? q -> name.equals(q.getName()) : q -> name.equalsIgnoreCase(q.getName());
        return this.findQuestion(filter);
    }

    @JsonIgnore
    public Optional<ApplicationFormQuestion> findQuestion(String name, String value, boolean ignoreCase) {
        Predicate<ApplicationFormQuestion> filter = ignoreCase ? q -> name.equals(q.getName()) : q -> name.equalsIgnoreCase(q.getName());
        filter.and(applicationFormQuestion -> applicationFormQuestion.getValue() != null && applicationFormQuestion.getValue().toLowerCase().contains(value));
        return this.findQuestion(filter);
    }

    @JsonIgnore
    public Optional<ApplicationFormQuestion> findQuestion(Predicate<ApplicationFormQuestion> filter) {
        return this.getQuestionStream().filter(filter).findFirst();
    }

    @JsonIgnore
    public List<ApplicationFormQuestion> getQuestionList() {
        return this.getQuestionStream().collect(Collectors.toList());
    }

    @JsonIgnore
    public Stream<ApplicationFormQuestion> getQuestionStream() {
        return this.applicationForm.getSteps().stream().flatMap(applicationFormStep -> applicationFormStep.getQuestionGroups().stream()).flatMap(questionGroup -> questionGroup.getQuestions().stream());
    }
}

