/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.imcode.entities.AcademicYear;
import com.imcode.entities.AfterSchoolCenterSection;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.entities.School;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.Truancy;
import com.imcode.entities.embed.AfterSchoolCenterSchema;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.json.GuardiansSetSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="dbo_pupil")
public class Pupil
extends AbstractIdEntity<Long>
implements Serializable,
JpaPersonalizedEntity {
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="person_id")
    private Person person = new Person();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="contact_person_id")
    private Person contactPerson;
    @Temporal(value=TemporalType.DATE)
    @Column(name="class_placement_from")
    private Date classPlacementFrom;
    @Temporal(value=TemporalType.DATE)
    @Column(name="class_placement_to")
    private Date classPlacementTo;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="school_class_id")
    private SchoolClass schoolClass;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="school_id")
    private School school;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="academic_year_id")
    private AcademicYear academicYear;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="dbo_pupil_guardians_cross", joinColumns={@JoinColumn(name="pupil_id")}, inverseJoinColumns={@JoinColumn(name="guardian_id")})
    @JsonSerialize(using=GuardiansSetSerializer.class)
    private Set<Guardian> guardians = new HashSet<Guardian>();
    @OneToMany(mappedBy="pupil", fetch=FetchType.EAGER)
    private Set<Truancy> truancies = new HashSet<Truancy>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="after_school_center_section_id")
    private AfterSchoolCenterSection afterSchoolCenterSection;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_pupil_after_school_center_schema", joinColumns={@JoinColumn(name="owner_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"owner_id", "after_school_section_id", "day_of_week"})})
    private List<AfterSchoolCenterSchema> schoolCenterSchema = new ArrayList<AfterSchoolCenterSchema>();

    @Override
    public Person getPerson() {
        return this.person;
    }

    @Override
    public void setPerson(Person person) {
        this.person = person;
    }

    @JsonIgnoreProperties(value={"pupils"})
    public SchoolClass getSchoolClass() {
        return this.schoolClass;
    }

    public void setSchoolClass(SchoolClass schoolClass) {
        this.schoolClass = schoolClass;
    }

    public AcademicYear getAcademicYear() {
        return this.academicYear;
    }

    public void setAcademicYear(AcademicYear academicYear) {
        this.academicYear = academicYear;
    }

    public Set<Truancy> getTruancies() {
        return this.truancies;
    }

    public void setTruancies(Set<Truancy> truancies) {
        this.truancies = truancies;
    }

    public Set<Guardian> getGuardians() {
        return this.guardians;
    }

    public void setGuardians(Set<Guardian> guardians) {
        this.guardians = guardians;
    }

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school) {
        this.school = school;
    }

    public Person getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(Person contactPerson) {
        this.contactPerson = contactPerson;
    }

    public Date getClassPlacementFrom() {
        return this.classPlacementFrom;
    }

    public void setClassPlacementFrom(Date classPlacementFrom) {
        this.classPlacementFrom = classPlacementFrom;
    }

    public Date getClassPlacementTo() {
        return this.classPlacementTo;
    }

    public void setClassPlacementTo(Date classPlacementTo) {
        this.classPlacementTo = classPlacementTo;
    }

    public List<AfterSchoolCenterSchema> getSchoolCenterSchema() {
        return this.schoolCenterSchema;
    }

    public void setSchoolCenterSchema(List<AfterSchoolCenterSchema> schoolCenterSchema) {
        this.schoolCenterSchema = schoolCenterSchema;
    }

    public AfterSchoolCenterSection getAfterSchoolCenterSection() {
        return this.afterSchoolCenterSection;
    }

    public void setAfterSchoolCenterSection(AfterSchoolCenterSection afterSchoolCenterSection) {
        this.afterSchoolCenterSection = afterSchoolCenterSection;
    }

    @Override
    public String toString() {
        return Objects.toString(this.person.toString());
    }
}

