/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.imcode.entities.ApplicationFormQuestionGroup;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.superclasses.AbstractSortableNamedEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.AttributeConverter;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="dbo_application_form_question")
public class ApplicationFormQuestion
extends AbstractSortableNamedEntity<Long>
implements Serializable {
    @Column
    private String text;
    @Column
    private String value;
    @Column(name="multi_values")
    private Boolean multiValues = Boolean.FALSE;
    @Column(name="valuez")
    @Convert(converter=ListToStringConverter.class)
    private List<String> values = new ArrayList<String>();
    @Column(name="multi_variants", nullable=false)
    private Boolean multiVariants = Boolean.FALSE;
    @Convert(converter=ListToStringConverter.class)
    private List<String> variants = new ArrayList<String>();
    @Column(name="question_type")
    private String questionType;
    @ManyToOne
    @JoinColumn(name="question_group_id")
    private ApplicationFormQuestionGroup questionGroup;

    public ApplicationFormQuestion() {
    }

    public ApplicationFormQuestion(String name, String text, String value, String questionType) {
        this(name, null, text, value, false, Collections.singletonList(value), String.class, false, Collections.emptyList(), questionType, null);
    }

    public ApplicationFormQuestion(String name, Integer sortOrder, String text, String value, Boolean multiValues, List<String> values, Class<? extends Serializable> valueType, Boolean multiVariants, List<String> variants, String questionType, ApplicationFormQuestionGroup questionGroup) {
        super(null, name, sortOrder);
        this.text = text;
        this.value = value;
        this.multiValues = multiValues;
        this.values = values;
        this.multiVariants = multiVariants;
        this.variants = variants;
        this.questionType = questionType;
        this.questionGroup = questionGroup;
    }

    @JsonIgnoreProperties(value={"questions"})
    public ApplicationFormQuestionGroup getQuestionGroup() {
        return this.questionGroup;
    }

    public void setQuestionGroup(ApplicationFormQuestionGroup questionGroup) {
        this.questionGroup = questionGroup;
    }

    public String getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getMultiValues() {
        return this.multiValues;
    }

    public void setMultiValues(Boolean multiValues) {
        this.multiValues = multiValues;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public Boolean getMultiVariants() {
        return this.multiVariants;
    }

    public void setMultiVariants(Boolean multiVariants) {
        this.multiVariants = multiVariants;
    }

    public List<String> getVariants() {
        return this.variants;
    }

    public void setVariants(List<String> variants) {
        this.variants = variants;
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (!super.deepEquals(entity)) {
            return false;
        }
        ApplicationFormQuestion that = (ApplicationFormQuestion)entity;
        return Objects.equals(this.text, that.text) && Objects.equals(this.questionType, that.questionType) && Objects.equals(this.value, that.value) && Objects.equals(this.multiValues, that.multiValues) && Objects.equals(this.values, that.values) && Objects.equals(this.multiVariants, that.multiVariants) && Objects.equals(this.variants, that.variants);
    }

    public static class ListToStringConverter
    implements AttributeConverter<List, String> {
        public String convertToDatabaseColumn(List attribute) {
            List stringList = attribute;
            return stringList.stream().collect(Collectors.joining(","));
        }

        public List convertToEntityAttribute(String dbData) {
            return new ArrayList<String>(Arrays.asList(dbData.split(",")));
        }
    }

    public class Helper<T extends Serializable> {
        private Helper() {
        }

        public T getValue() {
            return (T)ApplicationFormQuestion.this.value;
        }

        public List<T> getValues() {
            return ApplicationFormQuestion.this.values;
        }

        public List<T> getVariants() {
            return ApplicationFormQuestion.this.variants;
        }
    }
}

