/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.EntityRestProviderInformation;
import com.imcode.entities.User;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.springframework.web.bind.annotation.RequestMethod;

@Entity
@Table(name="dbo_method_rest_provider_for_entity")
public class MethodRestProviderForEntity
extends AbstractNamedEntity<Long>
implements Serializable {
    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @MapKeyColumn(name="name", length=100)
    @Column(name="type")
    @CollectionTable(name="dbo_method_in_parameters", joinColumns={@JoinColumn(name="method_id")})
    private Map<String, String> inParameters = new LinkedHashMap<String, String>();
    @Column(name="out_parameter")
    private String outParameter;
    @Column
    private String url;
    @Column(name="request_method")
    @Enumerated(value=EnumType.STRING)
    private RequestMethod requestMethod;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="entity_rest_provider_info_id")
    private EntityRestProviderInformation entityRestProviderInformation;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_method_rest_provider_for_entity_user_cross", joinColumns={@JoinColumn(name="method_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    private Set<User> users = new HashSet<User>();
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_method_rest_provider_for_entity_client_cross", joinColumns={@JoinColumn(name="method_id")}, inverseJoinColumns={@JoinColumn(name="client_id")})
    private Set<JpaClientDetails> clients = new HashSet<JpaClientDetails>();

    public Map<String, String> getInParameters() {
        return this.inParameters;
    }

    public void setInParameters(Map<String, String> inParameters) {
        this.inParameters = inParameters;
    }

    public String getOutParameter() {
        return this.outParameter;
    }

    public void setOutParameter(String outParameter) {
        this.outParameter = outParameter;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public EntityRestProviderInformation getEntityRestProviderInformation() {
        return this.entityRestProviderInformation;
    }

    public void setEntityRestProviderInformation(EntityRestProviderInformation entityRestProviderInformation) {
        this.entityRestProviderInformation = entityRestProviderInformation;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public Set<JpaClientDetails> getClients() {
        return this.clients;
    }

    public void setClients(Set<JpaClientDetails> clients) {
        this.clients = clients;
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void deleteUser(Long userId) {
        this.users.removeIf(user -> ((Long)user.getId()).equals(userId));
    }

    public void addClient(JpaClientDetails clientDetails) {
        this.clients.add(clientDetails);
    }

    public void deleteClient(String clientId) {
        this.clients.removeIf(clientDetails -> clientDetails.getClientId().equals(clientId));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodRestProviderForEntity that = (MethodRestProviderForEntity)o;
        if (this.inParameters != null ? !this.inParameters.equals(that.inParameters) : that.inParameters != null) {
            return false;
        }
        if (this.outParameter != null ? !this.outParameter.equals(that.outParameter) : that.outParameter != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return this.requestMethod == that.requestMethod;
    }
}

