/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.embed;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Embeddable
public class Diary {
    @Enumerated(value=EnumType.STRING)
    @Column(unique=true)
    private DayOfWeek dayOfWeek;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="hh:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column
    private Date startTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="hh:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column
    private Date endTime;

    public Diary() {
    }

    public Diary(DayOfWeek dayOfWeek, Date startTime, Date endTime) {
        this.dayOfWeek = dayOfWeek;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Diary diary = (Diary)o;
        if (this.dayOfWeek != diary.dayOfWeek) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(diary.startTime) : diary.startTime != null) {
            return false;
        }
        return !(this.endTime == null ? diary.endTime != null : !this.endTime.equals(diary.endTime));
    }

    public int hashCode() {
        int result = this.dayOfWeek != null ? this.dayOfWeek.hashCode() : 0;
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
        StringBuilder sb = new StringBuilder().append(this.dayOfWeek).append(" (").append(dateFormat.format(this.startTime)).append(" - ").append(dateFormat.format(this.endTime)).append(')');
        return sb.toString();
    }
}

