/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.Category;
import com.imcode.entities.Issue;
import com.imcode.entities.Priority;
import com.imcode.entities.Status;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="dbo_incident")
public class Incident
extends AbstractIdEntity<Long>
implements Serializable {
    @Column(nullable=false)
    private String title;
    @Column
    private String description;
    @Column(name="report_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date reportDay;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_incident_categories_cross", joinColumns={@JoinColumn(name="incidentId")}, inverseJoinColumns={@JoinColumn(name="categoryId")})
    private Set<Category> categories = new HashSet<Category>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="statusId")
    private Status status;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="priorityId")
    private Priority priority;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="issueId")
    private Issue issue;

    public Incident() {
    }

    public Incident(Long aLong) {
        super(aLong);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getReportDay() {
        return this.reportDay;
    }

    public void setReportDay(Date reportDay) {
        this.reportDay = reportDay;
    }

    @JsonIgnore
    public Set<Category> getCategories() {
        return this.categories;
    }

    @JsonIgnore
    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }
}

