/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.observer;

import com.imcode.entities.interfaces.JpaAuditableEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class LogUtils {
    public static List<String> ignoredFields = Arrays.asList("willbesaved", "id", "createDate", "updateDate");

    public static Set<Difference> getDifferences(Map<String, Object> oldValues, Map<String, Object> newValues) {
        HashSet<Difference> differences = new HashSet<Difference>();
        for (Map.Entry<String, Object> entry : newValues.entrySet()) {
            Object oldForNew = oldValues.get(entry.getKey());
            if (oldForNew == null) {
                if (entry.getValue() == null) continue;
                differences.add(new Difference(null, entry));
                continue;
            }
            if (oldForNew.equals(entry.getValue())) continue;
            differences.add(new Difference(oldForNew, entry));
        }
        return differences;
    }

    public static Map<String, Object> getValues(JpaAuditableEntity model) {
        Field[] fields;
        Class<?> clazz = model.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = FieldUtils.getAllFields(clazz)) {
            if (field.getAnnotation(Transient.class) != null || ignoredFields.contains(field.getName())) continue;
            String capitalizedField = StringUtils.capitalize((String)field.getName());
            String getterName = "get" + capitalizedField;
            String isName = "is" + capitalizedField;
            MethodResult methodResult = LogUtils.runMethod(getterName, model);
            if (methodResult.run) {
                map.put(field.getName(), methodResult.value);
                continue;
            }
            methodResult = LogUtils.runMethod(isName, model);
            if (methodResult.run) {
                map.put(field.getName(), methodResult.value);
                continue;
            }
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(model));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return map;
    }

    private static MethodResult runMethod(String name, Object model) {
        return LogUtils.invokeMethod(LogUtils.getMethod(model.getClass(), name), model);
    }

    private static MethodResult invokeMethod(Method method, Object object) {
        if (method == null) {
            return MethodResult.didntRun();
        }
        try {
            return new MethodResult(true, method.invoke(object, new Object[0]));
        }
        catch (IllegalArgumentException e) {
            return MethodResult.didntRun();
        }
        catch (IllegalAccessException e) {
            return MethodResult.didntRun();
        }
        catch (InvocationTargetException e) {
            return MethodResult.didntRun();
        }
    }

    private static Method getMethod(Class<?> clazz, String getterName) {
        Method method = null;
        try {
            method = clazz.getMethod(getterName, new Class[0]);
        }
        catch (SecurityException e) {
            method = null;
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        return method;
    }

    public static class Difference {
        public Object oldValue;
        public Object newValue;
        public String field;

        public Difference(Object oldValue, Map.Entry<String, Object> newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue.getValue();
            this.field = newValue.getKey();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.newValue == null ? 0 : this.newValue.hashCode());
            result = 31 * result + (this.oldValue == null ? 0 : this.oldValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Difference other = (Difference)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.newValue == null ? other.newValue != null : !this.newValue.equals(other.newValue)) {
                return false;
            }
            return !(this.oldValue == null ? other.oldValue != null : !this.oldValue.equals(other.oldValue));
        }
    }

    public static class MethodResult {
        private boolean run;
        private Object value = null;

        public MethodResult(boolean run, Object value) {
            this.run = run;
            this.value = value;
        }

        public static MethodResult didntRun() {
            return new MethodResult(false, null);
        }
    }
}

