package com.imcode.entities;

import com.imcode.entities.superclasses.AbstractNamedEntity;
import org.springframework.security.core.GrantedAuthority;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "dbo_app_role")
public class ApplicationRole extends AbstractNamedEntity<Long> implements GrantedAuthority, Serializable{

    public ApplicationRole() { }

    public ApplicationRole(String name) {
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Role{");
        sb.append("id=").append(id);
        sb.append(", name='").append(name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getAuthority() {
        return name;
    }
}

