/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.superclasses;

import com.imcode.entities.interfaces.JpaContactedPerson;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.entities.superclasses.ContactInformation;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.springframework.util.StringUtils;

@MappedSuperclass
public abstract class AbstractPerson
extends AbstractIdEntity<Long>
implements Serializable,
JpaPersonalizedEntity,
JpaContactedPerson {
    @Column
    private String personalId;
    @Column
    private String firstName;
    @Column
    private String lastName;

    public AbstractPerson() {
    }

    public AbstractPerson(String pid, String firstName, String lastName) {
        this.personalId = pid;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)this.firstName)) {
            this.addWord(sb, this.firstName);
        }
        if (StringUtils.hasText((String)this.lastName)) {
            this.addWord(sb, this.lastName);
        }
        if (sb.length() == 0) {
            this.addWord(sb, this.personalId);
        }
        return sb.toString();
    }

    private void addWord(StringBuilder sb, String word) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(' ');
        }
        sb.append(word);
    }

    protected <K extends Enum<K>, V extends ContactInformation<K>> void putAddressValueIntoMap(Class<K> enumClass, V addressValue, Map<K, V> map) {
        Objects.requireNonNull(addressValue);
        K addressValueType = addressValue.getType();
        Objects.requireNonNull(addressValueType);
        if (map == null) {
            map = new EnumMap(enumClass);
        }
        map.put(addressValueType, addressValue);
    }
}

